package jp.hasc.hasctool.core.runtime.filter.file.table;

import jp.hasc.hasctool.core.runtime.filter.AbstractFilter;
import jp.hasc.hasctool.core.data.EnumCommand;
import jp.hasc.hasctool.core.runtime.RuntimeContext;

/**
 * CSVデータに含まれる情報を取得するフィルタです
 * @author hiro
 */

public abstract class AbstractElementFilter extends AbstractFilter{

	String element_;

	@Override
	public void setup(RuntimeContext context) {
		super.setup(context);
	}

	@Override
	public void processMessage(Object message) throws InterruptedException {
		if (message instanceof String) {
			String s =(String)message;
			String inf = getFeature(s);
			outputMessage(inf);
		}else if (message==EnumCommand.BEGIN) {
			outputMessage(EnumCommand.BEGIN);
			outputMessage(element_);
		}else {
			//END message
			outputMessage(message);
		}
	}

	abstract String getFeature(String filePath);

}
