package jp.hasc.hasctool.core.runtime.filter.file.path;

import jp.hasc.hasctool.core.runtime.RuntimeContext;
import jp.hasc.hasctool.core.runtime.filter.AbstractFilter;

/**
 * 入力されたfilePathにelement_が含まれるか否かで
 * フィルタリングします
 * @author hiro
 */

public class FilePathFilter extends AbstractFilter{

	private String element_;

	@Override
	public void setup(RuntimeContext context) {
		super.setup(context);
	}

	@Override
	public void processMessage(Object message) throws InterruptedException {
		if (message instanceof String) {
			String filePath =(String)message;
			if (0 <= filePath.indexOf(element_)){
				outputMessage(filePath);
			}
		}else{
			//BEGIN,END message
			outputMessage(message);
		}
	}

	public void setElement(String element){
		element_ = element;
	}
}
