package jp.hasc.hasctool.core.runtime.filter.file.path;

import java.util.HashMap;

import jp.hasc.hasctool.core.runtime.RuntimeContext;
import jp.hasc.hasctool.core.runtime.filter.AbstractFilter;

/**
 * ファイルPathを入力順にカウントしながら自動生成します
 * @author hiro
 */

public class FilePathCreator extends AbstractFilter{

	private HashMap<String, Integer> hmap_;
	private int folderClass_;
	private String feature_;
	private int count_;
	
	@Override
	public void setup(RuntimeContext context) {
		super.setup(context);
		hmap_ = new HashMap<String, Integer>();//entry,personの組み合わせ
	}
	
	
	@Override
	public void processMessage(Object message) throws InterruptedException {
		if (message instanceof String) {
			String s =(String)message;
			String[] part = s.split("/");
			String entry = part[part.length - folderClass_ -2];
			String person = part[part.length - folderClass_];
			String key = entry +"_"+ person;
			if(!(hmap_.containsKey(key))){//同entry・同personならcountしない
				count_++;
				hmap_.put(key, count_);
			}
			int num = hmap_.get(key);
			outputMessage(s.replace(person, feature_ + num));
		}else{
			//BEGIN,END message
			outputMessage(message);
		}
	}

	public void setFeature(String feature){
		feature_ = feature;
	}
	
	public void setStart(int count){
		count_ = count;
	}
	
	public void setFolderClass(int fc){
		folderClass_ = fc + 1;
	}

}
