package jp.hasc.hasctool.core.runtime.filter.file.label;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;

import jp.hasc.hasctool.core.data.EnumCommand;
import jp.hasc.hasctool.core.runtime.filter.AbstractFilter;
import jp.hasc.hasctool.core.runtime.RuntimeContext;
import jp.hasc.hasctool.core.util.CoreUtil;

/**
 * label情報に基づいて Label 名毎に波形を出力する
 *  (とりあえずActivity 専用)
 * @author kawaguti
 */

public class LabelCutter extends AbstractFilter{
	
	
	private String srcString_;
	private String srcRegex_;
	private String destString_;

	boolean start_ = true;
	String filePath_;
	LabelData[] ld_ = new LabelData[200];// currently only allow 200 labels.
	int index_ = 0;

	
	
	@Override
	public void setup(RuntimeContext context) {
		super.setup(context);
	}

	int fileCount_=0;
	OutputStream openOutStream(String label){
		String outPath = filePath_; // like "$(projectRoot)/activity/subj01/day01/set01-acc.csv"
		if (srcString_!=null) {
			outPath = filePath_.replace(srcString_, destString_);
		}else if (srcRegex_!=null) {
			outPath = filePath_.replaceAll(srcRegex_, destString_);
		}
		int li = outPath.lastIndexOf(".csv"); // find last ".csv"
		outPath = outPath.substring(0,li);// remove .csv
		outPath += "/"+label+"/seg"+Integer.toString(1000+fileCount_)+".csv";
		fileCount_++;
		
		OutputStream oups = getRuntimeContext().getFileStreamProvider().openOutputStream(outPath);
		return oups;
	}
	
	@Override
	public void processMessage(Object message) throws InterruptedException {
		if (message instanceof String) {
			String line =(String)message;
			if(start_){// first line should contain FilePath of the data.
				String[] row = line.split(":");
				filePath_ = row[1];
				start_ = false;
			}else if(line.contains(",")){ // assume labels do not overlap and sorted.
				String[] row = line.split(",");
				double start = Double.parseDouble(row[0]);
				double end = Double.parseDouble(row[1]);
				ld_[index_] = new LabelData(start, end, row[2]);
				index_++;
			}
		} else if (message == EnumCommand.END) {
			try{
				// open signal file
				InputStream inps = getRuntimeContext().getFileStreamProvider().openInputStream(filePath_);
				BufferedReader bufferedReader = 
					new BufferedReader(new InputStreamReader(inps, RuntimeContext.DEFAULT_CHARSET));


				int ind=0; // for SignalName;
				boolean finished = true;
				OutputStream ost=null;
				BufferedWriter bw=null;
				
				while(true){
					if( finished && ind < index_){
						ost = openOutStream(ld_[ind].label_);
						bw = new BufferedWriter(new OutputStreamWriter(ost,RuntimeContext.DEFAULT_CHARSET));
						finished = false; 
					}
					String line = bufferedReader.readLine();
					if (line == null) {
						break;
					} else{ // read signal line.
						String[] val = line.split(",");
						double time = Double.parseDouble(val[0]);
						if( ld_[ind].start_ > time) continue;
						
						if( ld_[ind].end_ <= time ) { // finished 
							if(!finished){ // file opened
								bw.close();
								ost.close();
								finished = true;
								if(ind < index_){
									ind++;
								}else{
									break; // finished all labals
								}
							}							
						}else{ // start < time < end
							bw.write(line);
							bw.newLine();
						}						
					}

				}// while(true)
				if(!finished){ // file opened
					bw.close();
					ost.close();
				}							
				bufferedReader.close();
				inps.close();
			} catch (IOException ex) {
				CoreUtil.throwAsRuntimeException(ex);
			} catch (RuntimeException ex) {
			}
			outputMessage(EnumCommand.END);
		} else {
			//BEGIN message
			outputMessage(message);
		}
	}
	
	/**
	 * 置換元の文字列を指定します。
	 */
	public void setSrcString(String srcString) {
		srcString_ = srcString;
	}

	/**
	 * 置換先の文字列を指定します。
	 */
	public void setDestString(String destString) {
		destString_ = destString;
	}

	/**
	 * 置換元の文字列を正規表現で指定します。（srcStringがnullの場合のみ有効）
	 */
	public void setSrcRegex(String srcStringAsRegexp) {
		srcRegex_ = srcStringAsRegexp;
	}

}
