package jp.hasc.hasctool.core.messaging;

import java.util.ArrayList;

/**
 * 別のMessageProcessorに処理を委譲する、MessageProcessorです
 * @author iwasaki
 */
public class MessageConnector implements MessageProcessor {
	/** logger for this class */
	private final static org.apache.commons.logging.Log LOG = org.apache.commons.logging.LogFactory
			.getLog(MessageConnector.class);
	
	private ArrayList<MessageProcessor> delegates_=new ArrayList<MessageProcessor>();
	
	public MessageConnector() {
	}
	
	public MessageConnector(MessageProcessor delegate) {
		connect(delegate);
	}

	public void connect(MessageProcessor delegate) {
		delegates_.add(delegate);
	}
	
	public void disconnect(MessageProcessor delegate) {
		delegates_.remove(delegate);
	}
	
	@Override
	public void processMessage(Object message) throws InterruptedException {
		for(MessageProcessor p: delegates_) {
			if (p!=null) {
				p.processMessage(message);
			}else{
				LOG.warn("null MessageProcessor");
			}
		}
	}
}
