package jp.hasc.hasctool.core.data;

import java.util.concurrent.TimeUnit;

/**
 * 特定時刻の信号の値です。Immutable（生成後は変更禁止）です。
 * 信号をMessageProcessorに送る場合は、まず SignalMessage.BEGIN を送り、
 * 次に「時刻順」にSignalMessageを送り、最後に SignalMessage.END を送る必要があります。
 * @author iwasaki
 */
public interface SignalMessage {
	public static final TimeUnit TIME_UNIT = TimeUnit.MICROSECONDS;
	
	public static final EnumCommand BEGIN = EnumCommand.BEGIN;
	public static final EnumCommand END = EnumCommand.END;
	
	/**
	 * timeを返します。timeの単位は定数TIME_UNITです。
	 */
	public long getTime();
	
	/**
	 * 現在の time に delay を加算したものを返します
	 */
	public abstract SignalMessage createDelayedElement(long delay);
}
