package jp.hasc.hasctool.core.blockdiagram.model;

import java.util.ArrayList;
import java.util.Collections;

/**
 * ブロック図
 * @author iwasaki
 */
public class BlockDiagram extends AbstractModel{
	private static final long serialVersionUID = 1L;

	private ArrayList<AbstractBlock> blocks=new ArrayList<AbstractBlock>();
	
	private ArrayList<Connection> connections=new ArrayList<Connection>();
	
	private ArrayList<Shape> shapes=null;
	
	public Iterable<AbstractBlock> getBlocks() {
		return blocks;
	}
	
	public void addBlock(AbstractBlock block) {
		blocks.add(block);
	}

	public Iterable<Connection> getConnections() {
		return connections;
	}
	
	public void addConnection(Connection c) {
		connections.add(c);
	}
	
	public Iterable<Shape> getShapes() {
		if (shapes==null)  return Collections.emptyList();
		return shapes;
	}
	
	public void addShape(Shape c) {
		if (shapes==null) shapes=new ArrayList<Shape>();
		shapes.add(c);
	}

}
