#!/bin/bash

function process_common_pre {
	cd "$PLATFORM_DIR_PATH" || exit 1
	cp "$DIST_DIR_PATH/../readme.html" readme.html
	cp "$DIST_DIR_PATH/../readme_ja.html" readme_ja.html
	
	cd "$PLATFORM_DIR_PATH/$APP_DIR_NAME"
	sed -i '' '/^osgi\.instance\.area\.default/d' configuration/config.ini
}

function process_common_post {
	cd $PLATFORM_DIR_PATH
	ZIPNAME="../hasctool-$PLATFORM_NAME-`date +%Y%m%d`.zip"
	if [ -f "$ZIPNAME" ]; then rm "$ZIPNAME"; fi
	echo creating $PLATFORM_DIR_PATH/$ZIPNAME
	zip -q -r "$ZIPNAME" .
}

function process_macosx {
	process_common_pre
	
	cd "$PLATFORM_DIR_PATH/$APP_DIR_NAME"
	echo "osgi.instance.area.default=@user.home/Documents/hasc_workspace" >> configuration/config.ini
	
	process_common_post
}

function process_win32 {
	process_common_pre
	
	cd "$PLATFORM_DIR_PATH/$APP_DIR_NAME"
	echo "osgi.instance.area.default=@user.home/hasc_workspace" >> configuration/config.ini
	
	process_common_post
}

EXPORT_DIR_PATH="`pwd`"
DIST_DIR_PATH="`dirname $0`"
APP_DIR_NAME=hasctool

PLATFORM_DIR_PATH="$EXPORT_DIR_PATH/macosx.cocoa.x86"
PLATFORM_NAME=macosx
process_macosx

PLATFORM_DIR_PATH="$EXPORT_DIR_PATH/win32.win32.x86"
PLATFORM_NAME=win32
process_win32
