/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.explorer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Random;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;
import weka.classifiers.Classifier;
import weka.classifiers.CostMatrix;
import weka.classifiers.Evaluation;
import weka.classifiers.Sourcable;
import weka.classifiers.evaluation.CostCurve;
import weka.classifiers.evaluation.MarginCurve;
import weka.classifiers.evaluation.ThresholdCurve;
import weka.classifiers.pmml.consumer.PMMLClassifier;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.CapabilitiesHandler;
import weka.core.Drawable;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.OptionHandler;
import weka.core.Range;
import weka.core.SerializedObject;
import weka.core.Utils;
import weka.core.Version;
import weka.core.converters.ConverterUtils;
import weka.core.converters.IncrementalConverter;
import weka.core.converters.Loader;
import weka.core.pmml.PMMLFactory;
import weka.core.pmml.PMMLModel;
import weka.gui.CostMatrixEditor;
import weka.gui.ExtensionFileFilter;
import weka.gui.GenericObjectEditor;
import weka.gui.LogPanel;
import weka.gui.Logger;
import weka.gui.PropertyDialog;
import weka.gui.PropertyPanel;
import weka.gui.ResultHistoryPanel;
import weka.gui.SaveBuffer;
import weka.gui.SetInstancesPanel;
import weka.gui.SysErrLog;
import weka.gui.TaskLogger;
import weka.gui.beans.CostBenefitAnalysis;
import weka.gui.explorer.Explorer;
import weka.gui.explorer.ExplorerDefaults;
import weka.gui.graphvisualizer.BIFFormatException;
import weka.gui.graphvisualizer.GraphVisualizer;
import weka.gui.treevisualizer.NodePlace;
import weka.gui.treevisualizer.PlaceNode2;
import weka.gui.treevisualizer.TreeVisualizer;
import weka.gui.visualize.PlotData2D;
import weka.gui.visualize.ThresholdVisualizePanel;
import weka.gui.visualize.VisualizePanel;
import weka.gui.visualize.plugins.VisualizePlugin;

public class ClassifierPanel
extends JPanel
implements Explorer.CapabilitiesFilterChangeListener,
Explorer.ExplorerPanel,
Explorer.LogHandler {
    static final long serialVersionUID = 6959973704963624003L;
    protected Explorer m_Explorer = null;
    public static String MODEL_FILE_EXTENSION = ".model";
    public static String PMML_FILE_EXTENSION = ".xml";
    protected GenericObjectEditor m_ClassifierEditor = new GenericObjectEditor();
    protected PropertyPanel m_CEPanel = new PropertyPanel(this.m_ClassifierEditor);
    protected JTextArea m_OutText = new JTextArea(20, 40);
    protected Logger m_Log = new SysErrLog();
    SaveBuffer m_SaveOut = new SaveBuffer(this.m_Log, this);
    protected ResultHistoryPanel m_History = new ResultHistoryPanel(this.m_OutText);
    protected JComboBox m_ClassCombo = new JComboBox();
    protected JRadioButton m_CVBut = new JRadioButton("Cross-validation");
    protected JRadioButton m_PercentBut = new JRadioButton("Percentage split");
    protected JRadioButton m_TrainBut = new JRadioButton("Use training set");
    protected JRadioButton m_TestSplitBut = new JRadioButton("Supplied test set");
    protected JCheckBox m_StorePredictionsBut = new JCheckBox("Store predictions for visualization");
    protected JCheckBox m_OutputModelBut = new JCheckBox("Output model");
    protected JCheckBox m_OutputPerClassBut = new JCheckBox("Output per-class stats");
    protected JCheckBox m_OutputConfusionBut = new JCheckBox("Output confusion matrix");
    protected JCheckBox m_OutputEntropyBut = new JCheckBox("Output entropy evaluation measures");
    protected JCheckBox m_OutputPredictionsTextBut = new JCheckBox("Output predictions");
    protected JTextField m_OutputAdditionalAttributesText = new JTextField("", 10);
    protected JLabel m_OutputAdditionalAttributesLab = new JLabel("Output additional attributes");
    protected Range m_OutputAdditionalAttributesRange = null;
    protected JCheckBox m_EvalWRTCostsBut = new JCheckBox("Cost-sensitive evaluation");
    protected JButton m_SetCostsBut = new JButton("Set...");
    protected JLabel m_CVLab = new JLabel("Folds", 4);
    protected JTextField m_CVText = new JTextField("10", 3);
    protected JLabel m_PercentLab = new JLabel("%", 4);
    protected JTextField m_PercentText = new JTextField("66", 3);
    protected JButton m_SetTestBut = new JButton("Set...");
    protected JFrame m_SetTestFrame;
    protected PropertyDialog m_SetCostsFrame;
    ActionListener m_RadioListener = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            ClassifierPanel.this.updateRadioLinks();
        }
    };
    JButton m_MoreOptions = new JButton("More options...");
    protected JTextField m_RandomSeedText = new JTextField("1", 3);
    protected JLabel m_RandomLab = new JLabel("Random seed for XVal / % Split", 4);
    protected JCheckBox m_PreserveOrderBut = new JCheckBox("Preserve order for % Split");
    protected JCheckBox m_OutputSourceCode = new JCheckBox("Output source code");
    protected JTextField m_SourceCodeClass = new JTextField("WekaClassifier", 10);
    protected JButton m_StartBut = new JButton("Start");
    protected JButton m_StopBut = new JButton("Stop");
    private Dimension COMBO_SIZE;
    protected CostMatrixEditor m_CostMatrixEditor;
    protected Instances m_Instances;
    protected Loader m_TestLoader;
    protected Thread m_RunThread;
    protected VisualizePanel m_CurrentVis;
    protected FileFilter m_ModelFilter;
    protected FileFilter m_PMMLModelFilter;
    protected JFileChooser m_FileChooser;

    public ClassifierPanel() {
        this.COMBO_SIZE = new Dimension(150, this.m_StartBut.getPreferredSize().height);
        this.m_CostMatrixEditor = new CostMatrixEditor();
        this.m_CurrentVis = null;
        this.m_ModelFilter = new ExtensionFileFilter(MODEL_FILE_EXTENSION, "Model object files");
        this.m_PMMLModelFilter = new ExtensionFileFilter(PMML_FILE_EXTENSION, "PMML model files");
        this.m_FileChooser = new JFileChooser(new File(System.getProperty("user.dir")));
        this.m_OutText.setEditable(false);
        this.m_OutText.setFont(new Font("Monospaced", 0, 12));
        this.m_OutText.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.m_OutText.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if ((e.getModifiers() & 0x10) != 16) {
                    ClassifierPanel.this.m_OutText.selectAll();
                }
            }
        });
        this.m_History.setBorder(BorderFactory.createTitledBorder("Result list (right-click for options)"));
        this.m_ClassifierEditor.setClassType(Classifier.class);
        this.m_ClassifierEditor.setValue(ExplorerDefaults.getClassifier());
        this.m_ClassifierEditor.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                ClassifierPanel.this.m_StartBut.setEnabled(true);
                Capabilities currentFilter = ClassifierPanel.this.m_ClassifierEditor.getCapabilitiesFilter();
                Classifier classifier = (Classifier)ClassifierPanel.this.m_ClassifierEditor.getValue();
                Capabilities currentSchemeCapabilities = null;
                if (classifier != null && currentFilter != null && classifier instanceof CapabilitiesHandler && !(currentSchemeCapabilities = classifier.getCapabilities()).supportsMaybe(currentFilter) && !currentSchemeCapabilities.supports(currentFilter)) {
                    ClassifierPanel.this.m_StartBut.setEnabled(false);
                }
                ClassifierPanel.this.repaint();
            }
        });
        this.m_ClassCombo.setToolTipText("Select the attribute to use as the class");
        this.m_TrainBut.setToolTipText("Test on the same set that the classifier is trained on");
        this.m_CVBut.setToolTipText("Perform a n-fold cross-validation");
        this.m_PercentBut.setToolTipText("Train on a percentage of the data and test on the remainder");
        this.m_TestSplitBut.setToolTipText("Test on a user-specified dataset");
        this.m_StartBut.setToolTipText("Starts the classification");
        this.m_StopBut.setToolTipText("Stops a running classification");
        this.m_StorePredictionsBut.setToolTipText("Store predictions in the result list for later visualization");
        this.m_OutputModelBut.setToolTipText("Output the model obtained from the full training set");
        this.m_OutputPerClassBut.setToolTipText("Output precision/recall & true/false positives for each class");
        this.m_OutputConfusionBut.setToolTipText("Output the matrix displaying class confusions");
        this.m_OutputEntropyBut.setToolTipText("Output entropy-based evaluation measures");
        this.m_EvalWRTCostsBut.setToolTipText("Evaluate errors with respect to a cost matrix");
        this.m_OutputPredictionsTextBut.setToolTipText("Include the predictions in the output buffer");
        this.m_OutputAdditionalAttributesText.setToolTipText("Outputs additional attributes for the predictions, 'first' and 'last' are valid indices.");
        this.m_RandomLab.setToolTipText("The seed value for randomization");
        this.m_RandomSeedText.setToolTipText(this.m_RandomLab.getToolTipText());
        this.m_PreserveOrderBut.setToolTipText("Preserves the order in a percentage split");
        this.m_OutputSourceCode.setToolTipText("Whether to output the built classifier as Java source code");
        this.m_SourceCodeClass.setToolTipText("The classname of the built classifier");
        this.m_FileChooser.addChoosableFileFilter(this.m_PMMLModelFilter);
        this.m_FileChooser.setFileFilter(this.m_ModelFilter);
        this.m_FileChooser.setFileSelectionMode(0);
        this.m_StorePredictionsBut.setSelected(ExplorerDefaults.getClassifierStorePredictionsForVis());
        this.m_OutputModelBut.setSelected(ExplorerDefaults.getClassifierOutputModel());
        this.m_OutputPerClassBut.setSelected(ExplorerDefaults.getClassifierOutputPerClassStats());
        this.m_OutputConfusionBut.setSelected(ExplorerDefaults.getClassifierOutputConfusionMatrix());
        this.m_EvalWRTCostsBut.setSelected(ExplorerDefaults.getClassifierCostSensitiveEval());
        this.m_OutputEntropyBut.setSelected(ExplorerDefaults.getClassifierOutputEntropyEvalMeasures());
        this.m_OutputPredictionsTextBut.setSelected(ExplorerDefaults.getClassifierOutputPredictions());
        this.m_OutputPredictionsTextBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClassifierPanel.this.m_OutputAdditionalAttributesText.setEnabled(ClassifierPanel.this.m_OutputPredictionsTextBut.isSelected());
            }
        });
        this.m_OutputAdditionalAttributesText.setText(ExplorerDefaults.getClassifierOutputAdditionalAttributes());
        this.m_OutputAdditionalAttributesText.setEnabled(this.m_OutputPredictionsTextBut.isSelected());
        this.m_RandomSeedText.setText("" + ExplorerDefaults.getClassifierRandomSeed());
        this.m_PreserveOrderBut.setSelected(ExplorerDefaults.getClassifierPreserveOrder());
        this.m_OutputSourceCode.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClassifierPanel.this.m_SourceCodeClass.setEnabled(ClassifierPanel.this.m_OutputSourceCode.isSelected());
            }
        });
        this.m_OutputSourceCode.setSelected(ExplorerDefaults.getClassifierOutputSourceCode());
        this.m_SourceCodeClass.setText(ExplorerDefaults.getClassifierSourceCodeClass());
        this.m_SourceCodeClass.setEnabled(this.m_OutputSourceCode.isSelected());
        this.m_ClassCombo.setEnabled(false);
        this.m_ClassCombo.setPreferredSize(this.COMBO_SIZE);
        this.m_ClassCombo.setMaximumSize(this.COMBO_SIZE);
        this.m_ClassCombo.setMinimumSize(this.COMBO_SIZE);
        this.m_CVBut.setSelected(true);
        this.m_CVBut.setSelected(ExplorerDefaults.getClassifierTestMode() == 1);
        this.m_PercentBut.setSelected(ExplorerDefaults.getClassifierTestMode() == 2);
        this.m_TrainBut.setSelected(ExplorerDefaults.getClassifierTestMode() == 3);
        this.m_TestSplitBut.setSelected(ExplorerDefaults.getClassifierTestMode() == 4);
        this.m_PercentText.setText("" + ExplorerDefaults.getClassifierPercentageSplit());
        this.m_CVText.setText("" + ExplorerDefaults.getClassifierCrossvalidationFolds());
        this.updateRadioLinks();
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.m_TrainBut);
        bg.add(this.m_CVBut);
        bg.add(this.m_PercentBut);
        bg.add(this.m_TestSplitBut);
        this.m_TrainBut.addActionListener(this.m_RadioListener);
        this.m_CVBut.addActionListener(this.m_RadioListener);
        this.m_PercentBut.addActionListener(this.m_RadioListener);
        this.m_TestSplitBut.addActionListener(this.m_RadioListener);
        this.m_SetTestBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClassifierPanel.this.setTestSet();
            }
        });
        this.m_EvalWRTCostsBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClassifierPanel.this.m_SetCostsBut.setEnabled(ClassifierPanel.this.m_EvalWRTCostsBut.isSelected());
                if (ClassifierPanel.this.m_SetCostsFrame != null && !ClassifierPanel.this.m_EvalWRTCostsBut.isSelected()) {
                    ClassifierPanel.this.m_SetCostsFrame.setVisible(false);
                }
            }
        });
        this.m_CostMatrixEditor.setValue(new CostMatrix(1));
        this.m_SetCostsBut.setEnabled(this.m_EvalWRTCostsBut.isSelected());
        this.m_SetCostsBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int classIndex;
                int numClasses;
                ClassifierPanel.this.m_SetCostsBut.setEnabled(false);
                if (ClassifierPanel.this.m_SetCostsFrame == null) {
                    ClassifierPanel.this.m_SetCostsFrame = PropertyDialog.getParentDialog(ClassifierPanel.this) != null ? new PropertyDialog(PropertyDialog.getParentDialog(ClassifierPanel.this), (PropertyEditor)ClassifierPanel.this.m_CostMatrixEditor, 100, 100) : new PropertyDialog(PropertyDialog.getParentFrame(ClassifierPanel.this), (PropertyEditor)ClassifierPanel.this.m_CostMatrixEditor, 100, 100);
                    ClassifierPanel.this.m_SetCostsFrame.setTitle("Cost Matrix Editor");
                    ClassifierPanel.this.m_SetCostsFrame.addWindowListener(new WindowAdapter(){

                        public void windowClosing(WindowEvent p) {
                            ClassifierPanel.this.m_SetCostsBut.setEnabled(ClassifierPanel.this.m_EvalWRTCostsBut.isSelected());
                            if (ClassifierPanel.this.m_SetCostsFrame != null && !ClassifierPanel.this.m_EvalWRTCostsBut.isSelected()) {
                                ClassifierPanel.this.m_SetCostsFrame.setVisible(false);
                            }
                        }
                    });
                    ClassifierPanel.this.m_SetCostsFrame.setVisible(true);
                }
                if ((numClasses = ClassifierPanel.this.m_Instances.attribute(classIndex = ClassifierPanel.this.m_ClassCombo.getSelectedIndex()).numValues()) != ((CostMatrix)ClassifierPanel.this.m_CostMatrixEditor.getValue()).numColumns()) {
                    ClassifierPanel.this.m_CostMatrixEditor.setValue(new CostMatrix(numClasses));
                }
                ClassifierPanel.this.m_SetCostsFrame.setVisible(true);
            }
        });
        this.m_StartBut.setEnabled(false);
        this.m_StopBut.setEnabled(false);
        this.m_StartBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClassifierPanel.this.startClassifier();
            }
        });
        this.m_StopBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClassifierPanel.this.stopClassifier();
            }
        });
        this.m_ClassCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int selected = ClassifierPanel.this.m_ClassCombo.getSelectedIndex();
                if (selected != -1) {
                    boolean isNominal = ClassifierPanel.this.m_Instances.attribute(selected).isNominal();
                    ClassifierPanel.this.m_OutputPerClassBut.setEnabled(isNominal);
                    ClassifierPanel.this.m_OutputConfusionBut.setEnabled(isNominal);
                }
                ClassifierPanel.this.updateCapabilitiesFilter(ClassifierPanel.this.m_ClassifierEditor.getCapabilitiesFilter());
            }
        });
        this.m_History.setHandleRightClicks(false);
        this.m_History.getList().addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if ((e.getModifiers() & 0x10) != 16 || e.isAltDown()) {
                    int index = ClassifierPanel.this.m_History.getList().locationToIndex(e.getPoint());
                    if (index != -1) {
                        String name = ClassifierPanel.this.m_History.getNameAtIndex(index);
                        ClassifierPanel.this.visualize(name, e.getX(), e.getY());
                    } else {
                        ClassifierPanel.this.visualize(null, e.getX(), e.getY());
                    }
                }
            }
        });
        this.m_MoreOptions.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClassifierPanel.this.m_MoreOptions.setEnabled(false);
                JPanel moreOptionsPanel = new JPanel();
                moreOptionsPanel.setBorder(BorderFactory.createEmptyBorder(0, 5, 5, 5));
                moreOptionsPanel.setLayout(new GridLayout(11, 1));
                moreOptionsPanel.add(ClassifierPanel.this.m_OutputModelBut);
                moreOptionsPanel.add(ClassifierPanel.this.m_OutputPerClassBut);
                moreOptionsPanel.add(ClassifierPanel.this.m_OutputEntropyBut);
                moreOptionsPanel.add(ClassifierPanel.this.m_OutputConfusionBut);
                moreOptionsPanel.add(ClassifierPanel.this.m_StorePredictionsBut);
                moreOptionsPanel.add(ClassifierPanel.this.m_OutputPredictionsTextBut);
                JPanel additionalAttsPanel = new JPanel(new FlowLayout(0));
                additionalAttsPanel.add(ClassifierPanel.this.m_OutputAdditionalAttributesLab);
                additionalAttsPanel.add(ClassifierPanel.this.m_OutputAdditionalAttributesText);
                moreOptionsPanel.add(additionalAttsPanel);
                JPanel costMatrixOption = new JPanel(new FlowLayout(0));
                costMatrixOption.add(ClassifierPanel.this.m_EvalWRTCostsBut);
                costMatrixOption.add(ClassifierPanel.this.m_SetCostsBut);
                moreOptionsPanel.add(costMatrixOption);
                JPanel seedPanel = new JPanel(new FlowLayout(0));
                seedPanel.add(ClassifierPanel.this.m_RandomLab);
                seedPanel.add(ClassifierPanel.this.m_RandomSeedText);
                moreOptionsPanel.add(seedPanel);
                moreOptionsPanel.add(ClassifierPanel.this.m_PreserveOrderBut);
                JPanel sourcePanel = new JPanel(new FlowLayout(0));
                ClassifierPanel.this.m_OutputSourceCode.setEnabled(ClassifierPanel.this.m_ClassifierEditor.getValue() instanceof Sourcable);
                ClassifierPanel.this.m_SourceCodeClass.setEnabled(ClassifierPanel.this.m_OutputSourceCode.isEnabled() && ClassifierPanel.this.m_OutputSourceCode.isSelected());
                sourcePanel.add(ClassifierPanel.this.m_OutputSourceCode);
                sourcePanel.add(ClassifierPanel.this.m_SourceCodeClass);
                moreOptionsPanel.add(sourcePanel);
                JPanel all = new JPanel();
                all.setLayout(new BorderLayout());
                JButton oK = new JButton("OK");
                JPanel okP = new JPanel();
                okP.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
                okP.setLayout(new GridLayout(1, 1, 5, 5));
                okP.add(oK);
                all.add((Component)moreOptionsPanel, "Center");
                all.add((Component)okP, "South");
                final JDialog jd = new JDialog(PropertyDialog.getParentFrame(ClassifierPanel.this), "Classifier evaluation options");
                jd.getContentPane().setLayout(new BorderLayout());
                jd.getContentPane().add((Component)all, "Center");
                jd.addWindowListener(new WindowAdapter(){

                    public void windowClosing(WindowEvent w) {
                        jd.dispose();
                        ClassifierPanel.this.m_MoreOptions.setEnabled(true);
                    }
                });
                oK.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent a) {
                        ClassifierPanel.this.m_MoreOptions.setEnabled(true);
                        jd.dispose();
                    }
                });
                jd.pack();
                jd.setLocation(ClassifierPanel.this.m_MoreOptions.getLocationOnScreen());
                jd.setVisible(true);
            }
        });
        JPanel p1 = new JPanel();
        p1.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Classifier"), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        p1.setLayout(new BorderLayout());
        p1.add((Component)this.m_CEPanel, "North");
        JPanel p2 = new JPanel();
        GridBagLayout gbL = new GridBagLayout();
        p2.setLayout(gbL);
        p2.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Test options"), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        GridBagConstraints gbC = new GridBagConstraints();
        gbC.anchor = 17;
        gbC.gridy = 0;
        gbC.gridx = 0;
        gbL.setConstraints(this.m_TrainBut, gbC);
        p2.add(this.m_TrainBut);
        gbC = new GridBagConstraints();
        gbC.anchor = 17;
        gbC.gridy = 1;
        gbC.gridx = 0;
        gbL.setConstraints(this.m_TestSplitBut, gbC);
        p2.add(this.m_TestSplitBut);
        gbC = new GridBagConstraints();
        gbC.anchor = 13;
        gbC.fill = 2;
        gbC.gridy = 1;
        gbC.gridx = 1;
        gbC.gridwidth = 2;
        gbC.insets = new Insets(2, 10, 2, 0);
        gbL.setConstraints(this.m_SetTestBut, gbC);
        p2.add(this.m_SetTestBut);
        gbC = new GridBagConstraints();
        gbC.anchor = 17;
        gbC.gridy = 2;
        gbC.gridx = 0;
        gbL.setConstraints(this.m_CVBut, gbC);
        p2.add(this.m_CVBut);
        gbC = new GridBagConstraints();
        gbC.anchor = 13;
        gbC.fill = 2;
        gbC.gridy = 2;
        gbC.gridx = 1;
        gbC.insets = new Insets(2, 10, 2, 10);
        gbL.setConstraints(this.m_CVLab, gbC);
        p2.add(this.m_CVLab);
        gbC = new GridBagConstraints();
        gbC.anchor = 13;
        gbC.fill = 2;
        gbC.gridy = 2;
        gbC.gridx = 2;
        gbC.weightx = 100.0;
        gbC.ipadx = 20;
        gbL.setConstraints(this.m_CVText, gbC);
        p2.add(this.m_CVText);
        gbC = new GridBagConstraints();
        gbC.anchor = 17;
        gbC.gridy = 3;
        gbC.gridx = 0;
        gbL.setConstraints(this.m_PercentBut, gbC);
        p2.add(this.m_PercentBut);
        gbC = new GridBagConstraints();
        gbC.anchor = 13;
        gbC.fill = 2;
        gbC.gridy = 3;
        gbC.gridx = 1;
        gbC.insets = new Insets(2, 10, 2, 10);
        gbL.setConstraints(this.m_PercentLab, gbC);
        p2.add(this.m_PercentLab);
        gbC = new GridBagConstraints();
        gbC.anchor = 13;
        gbC.fill = 2;
        gbC.gridy = 3;
        gbC.gridx = 2;
        gbC.weightx = 100.0;
        gbC.ipadx = 20;
        gbL.setConstraints(this.m_PercentText, gbC);
        p2.add(this.m_PercentText);
        gbC = new GridBagConstraints();
        gbC.anchor = 17;
        gbC.fill = 2;
        gbC.gridy = 4;
        gbC.gridx = 0;
        gbC.weightx = 100.0;
        gbC.gridwidth = 3;
        gbC.insets = new Insets(3, 0, 1, 0);
        gbL.setConstraints(this.m_MoreOptions, gbC);
        p2.add(this.m_MoreOptions);
        JPanel buttons = new JPanel();
        buttons.setLayout(new GridLayout(2, 2));
        buttons.add(this.m_ClassCombo);
        this.m_ClassCombo.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JPanel ssButs = new JPanel();
        ssButs.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        ssButs.setLayout(new GridLayout(1, 2, 5, 5));
        ssButs.add(this.m_StartBut);
        ssButs.add(this.m_StopBut);
        buttons.add(ssButs);
        JPanel p3 = new JPanel();
        p3.setBorder(BorderFactory.createTitledBorder("Classifier output"));
        p3.setLayout(new BorderLayout());
        JScrollPane js = new JScrollPane(this.m_OutText);
        p3.add((Component)js, "Center");
        js.getViewport().addChangeListener(new ChangeListener(){
            private int lastHeight;

            public void stateChanged(ChangeEvent e) {
                JViewport vp = (JViewport)e.getSource();
                int h = vp.getViewSize().height;
                if (h != this.lastHeight) {
                    this.lastHeight = h;
                    int x = h - vp.getExtentSize().height;
                    vp.setViewPosition(new Point(0, x));
                }
            }
        });
        JPanel mondo = new JPanel();
        gbL = new GridBagLayout();
        mondo.setLayout(gbL);
        gbC = new GridBagConstraints();
        gbC.fill = 2;
        gbC.gridy = 0;
        gbC.gridx = 0;
        gbL.setConstraints(p2, gbC);
        mondo.add(p2);
        gbC = new GridBagConstraints();
        gbC.anchor = 11;
        gbC.fill = 2;
        gbC.gridy = 1;
        gbC.gridx = 0;
        gbL.setConstraints(buttons, gbC);
        mondo.add(buttons);
        gbC = new GridBagConstraints();
        gbC.fill = 1;
        gbC.gridy = 2;
        gbC.gridx = 0;
        gbC.weightx = 0.0;
        gbL.setConstraints(this.m_History, gbC);
        mondo.add(this.m_History);
        gbC = new GridBagConstraints();
        gbC.fill = 1;
        gbC.gridy = 0;
        gbC.gridx = 1;
        gbC.gridheight = 3;
        gbC.weightx = 100.0;
        gbC.weighty = 100.0;
        gbL.setConstraints(p3, gbC);
        mondo.add(p3);
        this.setLayout(new BorderLayout());
        this.add((Component)p1, "North");
        this.add((Component)mondo, "Center");
    }

    protected void updateRadioLinks() {
        this.m_SetTestBut.setEnabled(this.m_TestSplitBut.isSelected());
        if (this.m_SetTestFrame != null && !this.m_TestSplitBut.isSelected()) {
            this.m_SetTestFrame.setVisible(false);
        }
        this.m_CVText.setEnabled(this.m_CVBut.isSelected());
        this.m_CVLab.setEnabled(this.m_CVBut.isSelected());
        this.m_PercentText.setEnabled(this.m_PercentBut.isSelected());
        this.m_PercentLab.setEnabled(this.m_PercentBut.isSelected());
    }

    public void setLog(Logger newLog) {
        this.m_Log = newLog;
    }

    public void setInstances(Instances inst) {
        this.m_Instances = inst;
        String[] attribNames = new String[this.m_Instances.numAttributes()];
        for (int i = 0; i < attribNames.length; ++i) {
            String type = "";
            switch (this.m_Instances.attribute(i).type()) {
                case 1: {
                    type = "(Nom) ";
                    break;
                }
                case 0: {
                    type = "(Num) ";
                    break;
                }
                case 2: {
                    type = "(Str) ";
                    break;
                }
                case 3: {
                    type = "(Dat) ";
                    break;
                }
                case 4: {
                    type = "(Rel) ";
                    break;
                }
                default: {
                    type = "(???) ";
                }
            }
            attribNames[i] = type + this.m_Instances.attribute(i).name();
        }
        this.m_ClassCombo.setModel(new DefaultComboBoxModel<String>(attribNames));
        if (attribNames.length > 0) {
            if (inst.classIndex() == -1) {
                this.m_ClassCombo.setSelectedIndex(attribNames.length - 1);
            } else {
                this.m_ClassCombo.setSelectedIndex(inst.classIndex());
            }
            this.m_ClassCombo.setEnabled(true);
            this.m_StartBut.setEnabled(this.m_RunThread == null);
            this.m_StopBut.setEnabled(this.m_RunThread != null);
        } else {
            this.m_StartBut.setEnabled(false);
            this.m_StopBut.setEnabled(false);
        }
    }

    protected void setTestSet() {
        if (this.m_SetTestFrame == null) {
            final SetInstancesPanel sp = new SetInstancesPanel();
            if (this.m_TestLoader != null) {
                try {
                    if (this.m_TestLoader.getStructure() != null) {
                        sp.setInstances(this.m_TestLoader.getStructure());
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            sp.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent e) {
                    ClassifierPanel.this.m_TestLoader = sp.getLoader();
                }
            });
            this.m_SetTestFrame = new JFrame("Test Instances");
            sp.setParentFrame(this.m_SetTestFrame);
            this.m_SetTestFrame.getContentPane().setLayout(new BorderLayout());
            this.m_SetTestFrame.getContentPane().add((Component)sp, "Center");
            this.m_SetTestFrame.pack();
        }
        this.m_SetTestFrame.setVisible(true);
    }

    public static void processClassifierPrediction(Instance toPredict, Classifier classifier, Evaluation eval, Instances plotInstances, FastVector plotShape, FastVector plotSize) {
        try {
            double pred = eval.evaluateModelOnceAndRecordPrediction(classifier, toPredict);
            if (plotInstances != null) {
                double[] values = new double[plotInstances.numAttributes()];
                for (int i = 0; i < plotInstances.numAttributes(); ++i) {
                    if (i < toPredict.classIndex()) {
                        values[i] = toPredict.value(i);
                        continue;
                    }
                    if (i == toPredict.classIndex()) {
                        values[i] = pred;
                        values[i + 1] = toPredict.value(i);
                        ++i;
                        continue;
                    }
                    values[i] = toPredict.value(i - 1);
                }
                plotInstances.add(new Instance(1.0, values));
                if (toPredict.classAttribute().isNominal()) {
                    if (toPredict.isMissing(toPredict.classIndex()) || Instance.isMissingValue(pred)) {
                        plotShape.addElement(new Integer(2000));
                    } else if (pred != toPredict.classValue()) {
                        plotShape.addElement(new Integer(1000));
                    } else {
                        plotShape.addElement(new Integer(-1));
                    }
                    plotSize.addElement(new Integer(2));
                } else {
                    Double errd = null;
                    if (!toPredict.isMissing(toPredict.classIndex()) && !Instance.isMissingValue(pred)) {
                        errd = new Double(pred - toPredict.classValue());
                        plotShape.addElement(new Integer(-1));
                    } else {
                        plotShape.addElement(new Integer(2000));
                    }
                    plotSize.addElement(errd);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void postProcessPlotInfo(FastVector plotSize) {
        double err;
        Double errd;
        int i;
        int maxpSize = 20;
        double maxErr = Double.NEGATIVE_INFINITY;
        double minErr = Double.POSITIVE_INFINITY;
        for (i = 0; i < plotSize.size(); ++i) {
            errd = (Double)plotSize.elementAt(i);
            if (errd == null) continue;
            err = Math.abs(errd);
            if (err < minErr) {
                minErr = err;
            }
            if (!(err > maxErr)) continue;
            maxErr = err;
        }
        for (i = 0; i < plotSize.size(); ++i) {
            errd = (Double)plotSize.elementAt(i);
            if (errd != null) {
                err = Math.abs(errd);
                if (maxErr - minErr > 0.0) {
                    double temp = (err - minErr) / (maxErr - minErr) * (double)maxpSize;
                    plotSize.setElementAt(new Integer((int)temp), i);
                    continue;
                }
                plotSize.setElementAt(new Integer(1), i);
                continue;
            }
            plotSize.setElementAt(new Integer(1), i);
        }
    }

    public static Instances setUpVisualizableInstances(Instances trainInstances) {
        Attribute predictedClass;
        FastVector hv = new FastVector();
        Attribute classAt = trainInstances.attribute(trainInstances.classIndex());
        if (classAt.isNominal()) {
            FastVector attVals = new FastVector();
            for (int i = 0; i < classAt.numValues(); ++i) {
                attVals.addElement(classAt.value(i));
            }
            predictedClass = new Attribute("predicted" + classAt.name(), attVals);
        } else {
            predictedClass = new Attribute("predicted" + classAt.name());
        }
        for (int i = 0; i < trainInstances.numAttributes(); ++i) {
            if (i == trainInstances.classIndex()) {
                hv.addElement(predictedClass);
            }
            hv.addElement(trainInstances.attribute(i).copy());
        }
        return new Instances(trainInstances.relationName() + "_predicted", hv, trainInstances.numInstances());
    }

    protected void printPredictionsHeader(StringBuffer outBuff, Instances inst, String title) {
        outBuff.append("=== Predictions on " + title + " ===\n\n");
        outBuff.append(" inst#,    actual, predicted, error");
        if (inst.classAttribute().isNominal()) {
            outBuff.append(", probability distribution");
        }
        if (this.m_OutputAdditionalAttributesRange != null) {
            outBuff.append(" (");
            boolean first = true;
            for (int i = 0; i < inst.numAttributes() - 1; ++i) {
                if (!this.m_OutputAdditionalAttributesRange.isInRange(i)) continue;
                if (!first) {
                    outBuff.append(",");
                } else {
                    first = false;
                }
                outBuff.append(inst.attribute(i).name());
            }
            outBuff.append(")");
        }
        outBuff.append("\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startClassifier() {
        if (this.m_RunThread == null) {
            ClassifierPanel classifierPanel = this;
            synchronized (classifierPanel) {
                this.m_StartBut.setEnabled(false);
                this.m_StopBut.setEnabled(true);
            }
            this.m_RunThread = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Loose catch block
                 */
                public void run() {
                    block127: {
                        ClassifierPanel.this.m_Log.statusMessage("Setting up...");
                        CostMatrix costMatrix = null;
                        Instances inst = new Instances(ClassifierPanel.this.m_Instances);
                        ConverterUtils.DataSource source = null;
                        Instances userTestStructure = null;
                        FastVector plotShape = new FastVector();
                        FastVector plotSize = new FastVector();
                        Instances predInstances = null;
                        long trainTimeStart = 0L;
                        long trainTimeElapsed = 0L;
                        try {
                            if (ClassifierPanel.this.m_TestLoader != null && ClassifierPanel.this.m_TestLoader.getStructure() != null) {
                                ClassifierPanel.this.m_TestLoader.reset();
                                source = new ConverterUtils.DataSource(ClassifierPanel.this.m_TestLoader);
                                userTestStructure = source.getStructure();
                            }
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                        if (ClassifierPanel.this.m_EvalWRTCostsBut.isSelected()) {
                            costMatrix = new CostMatrix((CostMatrix)ClassifierPanel.this.m_CostMatrixEditor.getValue());
                        }
                        boolean outputModel = ClassifierPanel.this.m_OutputModelBut.isSelected();
                        boolean outputConfusion = ClassifierPanel.this.m_OutputConfusionBut.isSelected();
                        boolean outputPerClass = ClassifierPanel.this.m_OutputPerClassBut.isSelected();
                        boolean outputSummary = true;
                        boolean outputEntropy = ClassifierPanel.this.m_OutputEntropyBut.isSelected();
                        boolean saveVis = ClassifierPanel.this.m_StorePredictionsBut.isSelected();
                        boolean outputPredictionsText = ClassifierPanel.this.m_OutputPredictionsTextBut.isSelected();
                        if (ClassifierPanel.this.m_OutputAdditionalAttributesText.getText().equals("")) {
                            ClassifierPanel.this.m_OutputAdditionalAttributesRange = null;
                        } else {
                            ClassifierPanel.this.m_OutputAdditionalAttributesRange = new Range(ClassifierPanel.this.m_OutputAdditionalAttributesText.getText());
                            ClassifierPanel.this.m_OutputAdditionalAttributesRange.setUpper(inst.numAttributes() - 1);
                        }
                        String grph = null;
                        int testMode = 0;
                        int numFolds = 10;
                        double percent = 66.0;
                        int classIndex = ClassifierPanel.this.m_ClassCombo.getSelectedIndex();
                        Classifier classifier = (Classifier)ClassifierPanel.this.m_ClassifierEditor.getValue();
                        Classifier template = null;
                        try {
                            template = Classifier.makeCopy(classifier);
                        }
                        catch (Exception ex) {
                            ClassifierPanel.this.m_Log.logMessage("Problem copying classifier: " + ex.getMessage());
                        }
                        Classifier fullClassifier = null;
                        StringBuffer outBuff = new StringBuffer();
                        String name = new SimpleDateFormat("HH:mm:ss - ").format(new Date());
                        String cname = classifier.getClass().getName();
                        name = cname.startsWith("weka.classifiers.") ? name + cname.substring("weka.classifiers.".length()) : name + cname;
                        String cmd = ClassifierPanel.this.m_ClassifierEditor.getValue().getClass().getName();
                        if (ClassifierPanel.this.m_ClassifierEditor.getValue() instanceof OptionHandler) {
                            cmd = cmd + " " + Utils.joinOptions(((OptionHandler)ClassifierPanel.this.m_ClassifierEditor.getValue()).getOptions());
                        }
                        Evaluation eval = null;
                        if (ClassifierPanel.this.m_CVBut.isSelected()) {
                            testMode = 1;
                            numFolds = Integer.parseInt(ClassifierPanel.this.m_CVText.getText());
                            if (numFolds <= 1) {
                                throw new Exception("Number of folds must be greater than 1");
                            }
                        } else if (ClassifierPanel.this.m_PercentBut.isSelected()) {
                            testMode = 2;
                            percent = Double.parseDouble(ClassifierPanel.this.m_PercentText.getText());
                            if (percent <= 0.0 || percent >= 100.0) {
                                throw new Exception("Percentage must be between 0 and 100");
                            }
                        } else if (ClassifierPanel.this.m_TrainBut.isSelected()) {
                            testMode = 3;
                        } else if (ClassifierPanel.this.m_TestSplitBut.isSelected()) {
                            testMode = 4;
                            if (source == null) {
                                throw new Exception("No user test set has been specified");
                            }
                            if (!inst.equalHeaders(userTestStructure)) {
                                throw new Exception("Train and test set are not compatible");
                            }
                            userTestStructure.setClassIndex(classIndex);
                        } else {
                            throw new Exception("Unknown test mode");
                        }
                        inst.setClassIndex(classIndex);
                        if (saveVis) {
                            predInstances = ClassifierPanel.setUpVisualizableInstances(inst);
                            predInstances.setClassIndex(inst.classIndex() + 1);
                        }
                        ClassifierPanel.this.m_Log.logMessage("Started " + cname);
                        ClassifierPanel.this.m_Log.logMessage("Command: " + cmd);
                        if (ClassifierPanel.this.m_Log instanceof TaskLogger) {
                            ((TaskLogger)((Object)ClassifierPanel.this.m_Log)).taskStarted();
                        }
                        outBuff.append("=== Run information ===\n\n");
                        outBuff.append("Scheme:       " + cname);
                        if (classifier instanceof OptionHandler) {
                            String[] o = classifier.getOptions();
                            outBuff.append(" " + Utils.joinOptions(o));
                        }
                        outBuff.append("\n");
                        outBuff.append("Relation:     " + inst.relationName() + '\n');
                        outBuff.append("Instances:    " + inst.numInstances() + '\n');
                        outBuff.append("Attributes:   " + inst.numAttributes() + '\n');
                        if (inst.numAttributes() < 100) {
                            for (int i = 0; i < inst.numAttributes(); ++i) {
                                outBuff.append("              " + inst.attribute(i).name() + '\n');
                            }
                        } else {
                            outBuff.append("              [list of attributes omitted]\n");
                        }
                        outBuff.append("Test mode:    ");
                        switch (testMode) {
                            case 3: {
                                outBuff.append("evaluate on training data\n");
                                break;
                            }
                            case 1: {
                                outBuff.append("" + numFolds + "-fold cross-validation\n");
                                break;
                            }
                            case 2: {
                                outBuff.append("split " + percent + "% train, remainder test\n");
                                break;
                            }
                            case 4: {
                                if (source.isIncremental()) {
                                    outBuff.append("user supplied test set:  size unknown (reading incrementally)\n");
                                    break;
                                }
                                outBuff.append("user supplied test set: " + source.getDataSet().numInstances() + " instances\n");
                            }
                        }
                        if (costMatrix != null) {
                            outBuff.append("Evaluation cost matrix:\n").append(costMatrix.toString()).append("\n");
                        }
                        outBuff.append("\n");
                        ClassifierPanel.this.m_History.addResult(name, outBuff);
                        ClassifierPanel.this.m_History.setSingle(name);
                        if (outputModel || testMode == 3 || testMode == 4) {
                            ClassifierPanel.this.m_Log.statusMessage("Building model on training data...");
                            trainTimeStart = System.currentTimeMillis();
                            classifier.buildClassifier(inst);
                            trainTimeElapsed = System.currentTimeMillis() - trainTimeStart;
                        }
                        if (outputModel) {
                            outBuff.append("=== Classifier model (full training set) ===\n\n");
                            outBuff.append(classifier.toString() + "\n");
                            outBuff.append("\nTime taken to build model: " + Utils.doubleToString((double)trainTimeElapsed / 1000.0, 2) + " seconds\n\n");
                            ClassifierPanel.this.m_History.updateResult(name);
                            if (classifier instanceof Drawable) {
                                grph = null;
                                try {
                                    grph = ((Drawable)((Object)classifier)).graph();
                                }
                                catch (Exception ex) {
                                    // empty catch block
                                }
                            }
                            SerializedObject so = new SerializedObject(classifier);
                            fullClassifier = (Classifier)so.getObject();
                        }
                        switch (testMode) {
                            case 3: {
                                ClassifierPanel.this.m_Log.statusMessage("Evaluating on training data...");
                                eval = new Evaluation(inst, costMatrix);
                                if (outputPredictionsText) {
                                    ClassifierPanel.this.printPredictionsHeader(outBuff, inst, "training set");
                                }
                                for (int jj = 0; jj < inst.numInstances(); ++jj) {
                                    ClassifierPanel.processClassifierPrediction(inst.instance(jj), classifier, eval, predInstances, plotShape, plotSize);
                                    if (outputPredictionsText) {
                                        outBuff.append(ClassifierPanel.this.predictionText(classifier, inst.instance(jj), jj + 1));
                                    }
                                    if (jj % 100 != 0) continue;
                                    ClassifierPanel.this.m_Log.statusMessage("Evaluating on training data. Processed " + jj + " instances...");
                                }
                                if (outputPredictionsText) {
                                    outBuff.append("\n");
                                }
                                outBuff.append("=== Evaluation on training set ===\n");
                                break;
                            }
                            case 1: {
                                ClassifierPanel.this.m_Log.statusMessage("Randomizing instances...");
                                int rnd = 1;
                                try {
                                    rnd = Integer.parseInt(ClassifierPanel.this.m_RandomSeedText.getText().trim());
                                }
                                catch (Exception ex) {
                                    ClassifierPanel.this.m_Log.logMessage("Trouble parsing random seed value");
                                    rnd = 1;
                                }
                                Random random = new Random(rnd);
                                inst.randomize(random);
                                if (inst.attribute(classIndex).isNominal()) {
                                    ClassifierPanel.this.m_Log.statusMessage("Stratifying instances...");
                                    inst.stratify(numFolds);
                                }
                                eval = new Evaluation(inst, costMatrix);
                                if (outputPredictionsText) {
                                    ClassifierPanel.this.printPredictionsHeader(outBuff, inst, "test data");
                                }
                                for (int fold = 0; fold < numFolds; ++fold) {
                                    ClassifierPanel.this.m_Log.statusMessage("Creating splits for fold " + (fold + 1) + "...");
                                    Instances train = inst.trainCV(numFolds, fold, random);
                                    eval.setPriors(train);
                                    ClassifierPanel.this.m_Log.statusMessage("Building model for fold " + (fold + 1) + "...");
                                    Classifier current = null;
                                    try {
                                        current = Classifier.makeCopy(template);
                                    }
                                    catch (Exception ex) {
                                        ClassifierPanel.this.m_Log.logMessage("Problem copying classifier: " + ex.getMessage());
                                    }
                                    current.buildClassifier(train);
                                    Instances test = inst.testCV(numFolds, fold);
                                    ClassifierPanel.this.m_Log.statusMessage("Evaluating model for fold " + (fold + 1) + "...");
                                    for (int jj = 0; jj < test.numInstances(); ++jj) {
                                        ClassifierPanel.processClassifierPrediction(test.instance(jj), current, eval, predInstances, plotShape, plotSize);
                                        if (!outputPredictionsText) continue;
                                        outBuff.append(ClassifierPanel.this.predictionText(current, test.instance(jj), jj + 1));
                                    }
                                }
                                if (outputPredictionsText) {
                                    outBuff.append("\n");
                                }
                                if (inst.attribute(classIndex).isNominal()) {
                                    outBuff.append("=== Stratified cross-validation ===\n");
                                    break;
                                }
                                outBuff.append("=== Cross-validation ===\n");
                                break;
                            }
                            case 2: {
                                if (!ClassifierPanel.this.m_PreserveOrderBut.isSelected()) {
                                    int rnd;
                                    ClassifierPanel.this.m_Log.statusMessage("Randomizing instances...");
                                    try {
                                        rnd = Integer.parseInt(ClassifierPanel.this.m_RandomSeedText.getText().trim());
                                    }
                                    catch (Exception ex) {
                                        ClassifierPanel.this.m_Log.logMessage("Trouble parsing random seed value");
                                        rnd = 1;
                                    }
                                    inst.randomize(new Random(rnd));
                                }
                                int trainSize = (int)Math.round((double)inst.numInstances() * percent / 100.0);
                                int testSize = inst.numInstances() - trainSize;
                                Instances train = new Instances(inst, 0, trainSize);
                                Instances test = new Instances(inst, trainSize, testSize);
                                ClassifierPanel.this.m_Log.statusMessage("Building model on training split (" + trainSize + " instances)...");
                                Classifier current = null;
                                try {
                                    current = Classifier.makeCopy(template);
                                }
                                catch (Exception ex) {
                                    ClassifierPanel.this.m_Log.logMessage("Problem copying classifier: " + ex.getMessage());
                                }
                                current.buildClassifier(train);
                                eval = new Evaluation(train, costMatrix);
                                ClassifierPanel.this.m_Log.statusMessage("Evaluating on test split...");
                                if (outputPredictionsText) {
                                    ClassifierPanel.this.printPredictionsHeader(outBuff, inst, "test split");
                                }
                                for (int jj = 0; jj < test.numInstances(); ++jj) {
                                    ClassifierPanel.processClassifierPrediction(test.instance(jj), current, eval, predInstances, plotShape, plotSize);
                                    if (outputPredictionsText) {
                                        outBuff.append(ClassifierPanel.this.predictionText(current, test.instance(jj), jj + 1));
                                    }
                                    if (jj % 100 != 0) continue;
                                    ClassifierPanel.this.m_Log.statusMessage("Evaluating on test split. Processed " + jj + " instances...");
                                }
                                if (outputPredictionsText) {
                                    outBuff.append("\n");
                                }
                                outBuff.append("=== Evaluation on test split ===\n");
                                break;
                            }
                            case 4: {
                                ClassifierPanel.this.m_Log.statusMessage("Evaluating on test data...");
                                eval = new Evaluation(inst, costMatrix);
                                if (outputPredictionsText) {
                                    ClassifierPanel.this.printPredictionsHeader(outBuff, inst, "test set");
                                }
                                int jj = 0;
                                while (source.hasMoreElements(userTestStructure)) {
                                    Instance instance = source.nextElement(userTestStructure);
                                    ClassifierPanel.processClassifierPrediction(instance, classifier, eval, predInstances, plotShape, plotSize);
                                    if (outputPredictionsText) {
                                        outBuff.append(ClassifierPanel.this.predictionText(classifier, instance, jj + 1));
                                    }
                                    if (++jj % 100 != 0) continue;
                                    ClassifierPanel.this.m_Log.statusMessage("Evaluating on test data. Processed " + jj + " instances...");
                                }
                                if (outputPredictionsText) {
                                    outBuff.append("\n");
                                }
                                outBuff.append("=== Evaluation on test set ===\n");
                                break;
                            }
                            default: {
                                throw new Exception("Test mode not implemented");
                            }
                        }
                        if (outputSummary) {
                            outBuff.append(eval.toSummaryString(outputEntropy) + "\n");
                        }
                        if (inst.attribute(classIndex).isNominal()) {
                            if (outputPerClass) {
                                outBuff.append(eval.toClassDetailsString() + "\n");
                            }
                            if (outputConfusion) {
                                outBuff.append(eval.toMatrixString() + "\n");
                            }
                        }
                        if (fullClassifier instanceof Sourcable && ClassifierPanel.this.m_OutputSourceCode.isSelected()) {
                            outBuff.append("=== Source code ===\n\n");
                            outBuff.append(Evaluation.wekaStaticWrapper((Sourcable)((Object)fullClassifier), ClassifierPanel.this.m_SourceCodeClass.getText()));
                        }
                        ClassifierPanel.this.m_History.updateResult(name);
                        ClassifierPanel.this.m_Log.logMessage("Finished " + cname);
                        ClassifierPanel.this.m_Log.statusMessage("OK");
                        Object var43_58 = null;
                        try {
                            if (!saveVis && outputModel) {
                                FastVector vv = new FastVector();
                                vv.addElement(fullClassifier);
                                Instances trainHeader = new Instances(ClassifierPanel.this.m_Instances, 0);
                                trainHeader.setClassIndex(classIndex);
                                vv.addElement(trainHeader);
                                if (grph != null) {
                                    vv.addElement(grph);
                                }
                                ClassifierPanel.this.m_History.addObject(name, vv);
                            } else if (saveVis && predInstances != null && predInstances.numInstances() > 0) {
                                if (predInstances.attribute(predInstances.classIndex()).isNumeric()) {
                                    ClassifierPanel.this.postProcessPlotInfo(plotSize);
                                }
                                ClassifierPanel.this.m_CurrentVis = new VisualizePanel();
                                ClassifierPanel.this.m_CurrentVis.setName(name + " (" + inst.relationName() + ")");
                                ClassifierPanel.this.m_CurrentVis.setLog(ClassifierPanel.this.m_Log);
                                PlotData2D tempd = new PlotData2D(predInstances);
                                tempd.setShapeSize(plotSize);
                                tempd.setShapeType(plotShape);
                                tempd.setPlotName(name + " (" + inst.relationName() + ")");
                                ClassifierPanel.this.m_CurrentVis.addPlot(tempd);
                                ClassifierPanel.this.m_CurrentVis.setColourIndex(predInstances.classIndex());
                                FastVector vv = new FastVector();
                                if (outputModel) {
                                    vv.addElement(fullClassifier);
                                    Instances trainHeader = new Instances(ClassifierPanel.this.m_Instances, 0);
                                    trainHeader.setClassIndex(classIndex);
                                    vv.addElement(trainHeader);
                                    if (grph != null) {
                                        vv.addElement(grph);
                                    }
                                }
                                vv.addElement(ClassifierPanel.this.m_CurrentVis);
                                if (eval != null && eval.predictions() != null) {
                                    vv.addElement(eval.predictions());
                                    vv.addElement(inst.classAttribute());
                                }
                                ClassifierPanel.this.m_History.addObject(name, vv);
                            }
                        }
                        catch (Exception ex2) {
                            ex2.printStackTrace();
                        }
                        if (this.isInterrupted()) {
                            ClassifierPanel.this.m_Log.logMessage("Interrupted " + cname);
                            ClassifierPanel.this.m_Log.statusMessage("Interrupted");
                        }
                        16 var44_61 = this;
                        synchronized (var44_61) {
                            ClassifierPanel.this.m_StartBut.setEnabled(true);
                            ClassifierPanel.this.m_StopBut.setEnabled(false);
                            ClassifierPanel.this.m_RunThread = null;
                        }
                        if (ClassifierPanel.this.m_Log instanceof TaskLogger) {
                            ((TaskLogger)((Object)ClassifierPanel.this.m_Log)).taskFinished();
                        }
                        break block127;
                        {
                            catch (Exception ex) {
                                ex.printStackTrace();
                                ClassifierPanel.this.m_Log.logMessage(ex.getMessage());
                                JOptionPane.showMessageDialog(ClassifierPanel.this, "Problem evaluating classifier:\n" + ex.getMessage(), "Evaluate classifier", 0);
                                ClassifierPanel.this.m_Log.statusMessage("Problem evaluating classifier");
                                Object var43_59 = null;
                                try {
                                    if (!saveVis && outputModel) {
                                        FastVector vv = new FastVector();
                                        vv.addElement(fullClassifier);
                                        Instances trainHeader = new Instances(ClassifierPanel.this.m_Instances, 0);
                                        trainHeader.setClassIndex(classIndex);
                                        vv.addElement(trainHeader);
                                        if (grph != null) {
                                            vv.addElement(grph);
                                        }
                                        ClassifierPanel.this.m_History.addObject(name, vv);
                                    } else if (saveVis && predInstances != null && predInstances.numInstances() > 0) {
                                        if (predInstances.attribute(predInstances.classIndex()).isNumeric()) {
                                            ClassifierPanel.this.postProcessPlotInfo(plotSize);
                                        }
                                        ClassifierPanel.this.m_CurrentVis = new VisualizePanel();
                                        ClassifierPanel.this.m_CurrentVis.setName(name + " (" + inst.relationName() + ")");
                                        ClassifierPanel.this.m_CurrentVis.setLog(ClassifierPanel.this.m_Log);
                                        PlotData2D tempd = new PlotData2D(predInstances);
                                        tempd.setShapeSize(plotSize);
                                        tempd.setShapeType(plotShape);
                                        tempd.setPlotName(name + " (" + inst.relationName() + ")");
                                        ClassifierPanel.this.m_CurrentVis.addPlot(tempd);
                                        ClassifierPanel.this.m_CurrentVis.setColourIndex(predInstances.classIndex());
                                        FastVector vv = new FastVector();
                                        if (outputModel) {
                                            vv.addElement(fullClassifier);
                                            Instances trainHeader = new Instances(ClassifierPanel.this.m_Instances, 0);
                                            trainHeader.setClassIndex(classIndex);
                                            vv.addElement(trainHeader);
                                            if (grph != null) {
                                                vv.addElement(grph);
                                            }
                                        }
                                        vv.addElement(ClassifierPanel.this.m_CurrentVis);
                                        if (eval != null && eval.predictions() != null) {
                                            vv.addElement(eval.predictions());
                                            vv.addElement(inst.classAttribute());
                                        }
                                        ClassifierPanel.this.m_History.addObject(name, vv);
                                    }
                                }
                                catch (Exception ex2) {
                                    ex2.printStackTrace();
                                }
                                if (this.isInterrupted()) {
                                    ClassifierPanel.this.m_Log.logMessage("Interrupted " + cname);
                                    ClassifierPanel.this.m_Log.statusMessage("Interrupted");
                                }
                                16 var44_62 = this;
                                synchronized (var44_62) {
                                    ClassifierPanel.this.m_StartBut.setEnabled(true);
                                    ClassifierPanel.this.m_StopBut.setEnabled(false);
                                    ClassifierPanel.this.m_RunThread = null;
                                }
                                if (ClassifierPanel.this.m_Log instanceof TaskLogger) {
                                    ((TaskLogger)((Object)ClassifierPanel.this.m_Log)).taskFinished();
                                }
                            }
                        }
                        catch (Throwable throwable) {
                            Object var43_60 = null;
                            try {
                                if (!saveVis && outputModel) {
                                    FastVector vv = new FastVector();
                                    vv.addElement(fullClassifier);
                                    Instances trainHeader = new Instances(ClassifierPanel.this.m_Instances, 0);
                                    trainHeader.setClassIndex(classIndex);
                                    vv.addElement(trainHeader);
                                    if (grph != null) {
                                        vv.addElement(grph);
                                    }
                                    ClassifierPanel.this.m_History.addObject(name, vv);
                                } else if (saveVis && predInstances != null && predInstances.numInstances() > 0) {
                                    if (predInstances.attribute(predInstances.classIndex()).isNumeric()) {
                                        ClassifierPanel.this.postProcessPlotInfo(plotSize);
                                    }
                                    ClassifierPanel.this.m_CurrentVis = new VisualizePanel();
                                    ClassifierPanel.this.m_CurrentVis.setName(name + " (" + inst.relationName() + ")");
                                    ClassifierPanel.this.m_CurrentVis.setLog(ClassifierPanel.this.m_Log);
                                    PlotData2D tempd = new PlotData2D(predInstances);
                                    tempd.setShapeSize(plotSize);
                                    tempd.setShapeType(plotShape);
                                    tempd.setPlotName(name + " (" + inst.relationName() + ")");
                                    ClassifierPanel.this.m_CurrentVis.addPlot(tempd);
                                    ClassifierPanel.this.m_CurrentVis.setColourIndex(predInstances.classIndex());
                                    FastVector vv = new FastVector();
                                    if (outputModel) {
                                        vv.addElement(fullClassifier);
                                        Instances trainHeader = new Instances(ClassifierPanel.this.m_Instances, 0);
                                        trainHeader.setClassIndex(classIndex);
                                        vv.addElement(trainHeader);
                                        if (grph != null) {
                                            vv.addElement(grph);
                                        }
                                    }
                                    vv.addElement(ClassifierPanel.this.m_CurrentVis);
                                    if (eval != null && eval.predictions() != null) {
                                        vv.addElement(eval.predictions());
                                        vv.addElement(inst.classAttribute());
                                    }
                                    ClassifierPanel.this.m_History.addObject(name, vv);
                                }
                            }
                            catch (Exception ex2) {
                                ex2.printStackTrace();
                            }
                            if (this.isInterrupted()) {
                                ClassifierPanel.this.m_Log.logMessage("Interrupted " + cname);
                                ClassifierPanel.this.m_Log.statusMessage("Interrupted");
                            }
                            16 var44_63 = this;
                            synchronized (var44_63) {
                                ClassifierPanel.this.m_StartBut.setEnabled(true);
                                ClassifierPanel.this.m_StopBut.setEnabled(false);
                                ClassifierPanel.this.m_RunThread = null;
                            }
                            if (ClassifierPanel.this.m_Log instanceof TaskLogger) {
                                ((TaskLogger)((Object)ClassifierPanel.this.m_Log)).taskFinished();
                            }
                            throw throwable;
                        }
                    }
                }
            };
            this.m_RunThread.setPriority(1);
            this.m_RunThread.start();
        }
    }

    protected String predictionText(Classifier classifier, Instance inst, int instNum) throws Exception {
        StringBuffer text = new StringBuffer();
        text.append(Utils.padLeft("" + instNum, 6) + " ");
        if (inst.classAttribute().isNominal()) {
            double pred;
            if (inst.classIsMissing()) {
                text.append(Utils.padLeft("?", 10) + " ");
            } else {
                text.append(Utils.padLeft("" + ((int)inst.classValue() + 1) + ":" + inst.stringValue(inst.classAttribute()), 10) + " ");
            }
            double[] probdist = null;
            if (inst.classAttribute().isNominal()) {
                probdist = classifier.distributionForInstance(inst);
                if (probdist[(int)(pred = (double)Utils.maxIndex(probdist))] <= 0.0) {
                    pred = Instance.missingValue();
                }
            } else {
                pred = classifier.classifyInstance(inst);
            }
            text.append(Utils.padLeft(Instance.isMissingValue(pred) ? "?" : (int)pred + 1 + ":" + inst.classAttribute().value((int)pred), 10) + " ");
            if (pred == inst.classValue()) {
                text.append(Utils.padLeft(" ", 6) + " ");
            } else {
                text.append(Utils.padLeft("+", 6) + " ");
            }
            if (inst.classAttribute().type() == 1) {
                for (int i = 0; i < probdist.length; ++i) {
                    if (i == (int)pred) {
                        text.append(" *");
                    } else {
                        text.append("  ");
                    }
                    text.append(Utils.doubleToString(probdist[i], 5, 3));
                }
            }
        } else {
            if (inst.classIsMissing()) {
                text.append(Utils.padLeft("?", 10) + " ");
            } else {
                text.append(Utils.doubleToString(inst.classValue(), 10, 3) + " ");
            }
            double pred = classifier.classifyInstance(inst);
            if (Instance.isMissingValue(pred)) {
                text.append(Utils.padLeft("?", 10) + " ");
            } else {
                text.append(Utils.doubleToString(pred, 10, 3) + " ");
            }
            if (!inst.classIsMissing() && !Instance.isMissingValue(pred)) {
                text.append(Utils.doubleToString(pred - inst.classValue(), 10, 3));
            }
        }
        if (this.m_OutputAdditionalAttributesRange != null) {
            text.append(" (");
            boolean first = true;
            for (int i = 0; i < inst.numAttributes() - 1; ++i) {
                if (!this.m_OutputAdditionalAttributesRange.isInRange(i)) continue;
                if (!first) {
                    text.append(",");
                } else {
                    first = false;
                }
                text.append(inst.toString(i));
            }
            text.append(")");
        }
        text.append("\n");
        return text.toString();
    }

    protected void visualize(String name, int x, int y) {
        final String selectedName = name;
        JPopupMenu resultListMenu = new JPopupMenu();
        JMenuItem visMainBuffer = new JMenuItem("View in main window");
        if (selectedName != null) {
            visMainBuffer.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ClassifierPanel.this.m_History.setSingle(selectedName);
                }
            });
        } else {
            visMainBuffer.setEnabled(false);
        }
        resultListMenu.add(visMainBuffer);
        JMenuItem visSepBuffer = new JMenuItem("View in separate window");
        if (selectedName != null) {
            visSepBuffer.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ClassifierPanel.this.m_History.openFrame(selectedName);
                }
            });
        } else {
            visSepBuffer.setEnabled(false);
        }
        resultListMenu.add(visSepBuffer);
        JMenuItem saveOutput = new JMenuItem("Save result buffer");
        if (selectedName != null) {
            saveOutput.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ClassifierPanel.this.saveBuffer(selectedName);
                }
            });
        } else {
            saveOutput.setEnabled(false);
        }
        resultListMenu.add(saveOutput);
        JMenuItem deleteOutput = new JMenuItem("Delete result buffer");
        if (selectedName != null) {
            deleteOutput.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ClassifierPanel.this.m_History.removeResult(selectedName);
                }
            });
        } else {
            deleteOutput.setEnabled(false);
        }
        resultListMenu.add(deleteOutput);
        resultListMenu.addSeparator();
        JMenuItem loadModel = new JMenuItem("Load model");
        loadModel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClassifierPanel.this.loadClassifier();
            }
        });
        resultListMenu.add(loadModel);
        FastVector o = null;
        if (selectedName != null) {
            o = (FastVector)this.m_History.getNamedObject(selectedName);
        }
        VisualizePanel temp_vp = null;
        String temp_grph = null;
        FastVector temp_preds = null;
        Attribute temp_classAtt = null;
        Classifier temp_classifier = null;
        Instances temp_trainHeader = null;
        if (o != null) {
            for (int i = 0; i < o.size(); ++i) {
                Object temp = o.elementAt(i);
                if (temp instanceof Classifier) {
                    temp_classifier = (Classifier)temp;
                    continue;
                }
                if (temp instanceof Instances) {
                    temp_trainHeader = (Instances)temp;
                    continue;
                }
                if (temp instanceof VisualizePanel) {
                    temp_vp = (VisualizePanel)temp;
                    continue;
                }
                if (temp instanceof String) {
                    temp_grph = (String)temp;
                    continue;
                }
                if (temp instanceof FastVector) {
                    temp_preds = (FastVector)temp;
                    continue;
                }
                if (!(temp instanceof Attribute)) continue;
                temp_classAtt = (Attribute)temp;
            }
        }
        final VisualizePanel vp = temp_vp;
        final String grph = temp_grph;
        final FastVector preds = temp_preds;
        final Attribute classAtt = temp_classAtt;
        final Classifier classifier = temp_classifier;
        final Instances trainHeader = temp_trainHeader;
        JMenuItem saveModel = new JMenuItem("Save model");
        if (classifier != null) {
            saveModel.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ClassifierPanel.this.saveClassifier(selectedName, classifier, trainHeader);
                }
            });
        } else {
            saveModel.setEnabled(false);
        }
        resultListMenu.add(saveModel);
        JMenuItem reEvaluate = new JMenuItem("Re-evaluate model on current test set");
        if (classifier != null && this.m_TestLoader != null) {
            reEvaluate.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ClassifierPanel.this.reevaluateModel(selectedName, classifier, trainHeader);
                }
            });
        } else {
            reEvaluate.setEnabled(false);
        }
        resultListMenu.add(reEvaluate);
        resultListMenu.addSeparator();
        JMenuItem visErrors = new JMenuItem("Visualize classifier errors");
        if (vp != null) {
            if (vp.getXIndex() == 0 && vp.getYIndex() == 1) {
                try {
                    vp.setXIndex(vp.getInstances().classIndex());
                    vp.setYIndex(vp.getInstances().classIndex() - 1);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            visErrors.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ClassifierPanel.this.visualizeClassifierErrors(vp);
                }
            });
        } else {
            visErrors.setEnabled(false);
        }
        resultListMenu.add(visErrors);
        JMenuItem visGrph = new JMenuItem("Visualize tree");
        if (grph != null) {
            if (((Drawable)((Object)temp_classifier)).graphType() == 1) {
                visGrph.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        String title = vp != null ? vp.getName() : selectedName;
                        ClassifierPanel.this.visualizeTree(grph, title);
                    }
                });
            } else if (((Drawable)((Object)temp_classifier)).graphType() == 2) {
                visGrph.setText("Visualize graph");
                visGrph.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        Thread th = new Thread(){

                            public void run() {
                                ClassifierPanel.this.visualizeBayesNet(grph, selectedName);
                            }
                        };
                        th.start();
                    }
                });
            } else {
                visGrph.setEnabled(false);
            }
        } else {
            visGrph.setEnabled(false);
        }
        resultListMenu.add(visGrph);
        JMenuItem visMargin = new JMenuItem("Visualize margin curve");
        if (preds != null) {
            visMargin.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    try {
                        MarginCurve tc = new MarginCurve();
                        Instances result = tc.getCurve(preds);
                        VisualizePanel vmc = new VisualizePanel();
                        vmc.setName(result.relationName());
                        vmc.setLog(ClassifierPanel.this.m_Log);
                        PlotData2D tempd = new PlotData2D(result);
                        tempd.setPlotName(result.relationName());
                        tempd.addInstanceNumberAttribute();
                        vmc.addPlot(tempd);
                        ClassifierPanel.this.visualizeClassifierErrors(vmc);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            });
        } else {
            visMargin.setEnabled(false);
        }
        resultListMenu.add(visMargin);
        JMenu visThreshold = new JMenu("Visualize threshold curve");
        if (preds != null && classAtt != null) {
            int i = 0;
            while (i < classAtt.numValues()) {
                JMenuItem clv = new JMenuItem(classAtt.value(i));
                final int classValue = i++;
                clv.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        try {
                            ThresholdCurve tc = new ThresholdCurve();
                            Instances result = tc.getCurve(preds, classValue);
                            ThresholdVisualizePanel vmc = new ThresholdVisualizePanel();
                            vmc.setROCString("(Area under ROC = " + Utils.doubleToString(ThresholdCurve.getROCArea(result), 4) + ")");
                            vmc.setLog(ClassifierPanel.this.m_Log);
                            vmc.setName(result.relationName() + ". (Class value " + classAtt.value(classValue) + ")");
                            PlotData2D tempd = new PlotData2D(result);
                            tempd.setPlotName(result.relationName());
                            tempd.addInstanceNumberAttribute();
                            boolean[] cp = new boolean[result.numInstances()];
                            for (int n = 1; n < cp.length; ++n) {
                                cp[n] = true;
                            }
                            tempd.setConnectPoints(cp);
                            vmc.addPlot(tempd);
                            ClassifierPanel.this.visualizeClassifierErrors(vmc);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                });
                visThreshold.add(clv);
            }
        } else {
            visThreshold.setEnabled(false);
        }
        resultListMenu.add(visThreshold);
        JMenu visCostBenefit = new JMenu("Cost/Benefit analysis");
        if (preds != null && classAtt != null && classAtt.isNominal()) {
            int i = 0;
            while (i < classAtt.numValues()) {
                JMenuItem clv = new JMenuItem(classAtt.value(i));
                final int classValue = i++;
                clv.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        try {
                            String cname;
                            ThresholdCurve tc = new ThresholdCurve();
                            Instances result = tc.getCurve(preds, classValue);
                            Attribute classAttToUse = classAtt;
                            if (classValue != 0) {
                                FastVector newNames = new FastVector();
                                newNames.addElement(classAtt.value(classValue));
                                for (int k = 0; k < classAtt.numValues(); ++k) {
                                    if (k == classValue) continue;
                                    newNames.addElement(classAtt.value(k));
                                }
                                classAttToUse = new Attribute(classAtt.name(), newNames);
                            }
                            CostBenefitAnalysis cbAnalysis = new CostBenefitAnalysis();
                            PlotData2D tempd = new PlotData2D(result);
                            tempd.setPlotName(result.relationName());
                            tempd.m_alwaysDisplayPointsOfThisSize = 10;
                            boolean[] cp = new boolean[result.numInstances()];
                            for (int n = 1; n < cp.length; ++n) {
                                cp[n] = true;
                            }
                            tempd.setConnectPoints(cp);
                            String windowTitle = "";
                            if (classifier != null && (cname = classifier.getClass().getName()).startsWith("weka.classifiers.")) {
                                windowTitle = "" + cname.substring("weka.classifiers.".length()) + " ";
                            }
                            windowTitle = windowTitle + " (class = " + classAttToUse.value(0) + ")";
                            cbAnalysis.setCurveData(tempd, classAttToUse);
                            ClassifierPanel.this.visualizeCostBenefitAnalysis(cbAnalysis, windowTitle);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                });
                visCostBenefit.add(clv);
            }
        } else {
            visCostBenefit.setEnabled(false);
        }
        resultListMenu.add(visCostBenefit);
        JMenu visCost = new JMenu("Visualize cost curve");
        if (preds != null && classAtt != null) {
            int i = 0;
            while (i < classAtt.numValues()) {
                JMenuItem clv = new JMenuItem(classAtt.value(i));
                final int classValue = i++;
                clv.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        try {
                            CostCurve cc = new CostCurve();
                            Instances result = cc.getCurve(preds, classValue);
                            VisualizePanel vmc = new VisualizePanel();
                            vmc.setLog(ClassifierPanel.this.m_Log);
                            vmc.setName(result.relationName() + ". (Class value " + classAtt.value(classValue) + ")");
                            PlotData2D tempd = new PlotData2D(result);
                            tempd.m_displayAllPoints = true;
                            tempd.setPlotName(result.relationName());
                            boolean[] connectPoints = new boolean[result.numInstances()];
                            for (int jj = 1; jj < connectPoints.length; jj += 2) {
                                connectPoints[jj] = true;
                            }
                            tempd.setConnectPoints(connectPoints);
                            vmc.addPlot(tempd);
                            ClassifierPanel.this.visualizeClassifierErrors(vmc);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                });
                visCost.add(clv);
            }
        } else {
            visCost.setEnabled(false);
        }
        resultListMenu.add(visCost);
        JMenu visPlugins = new JMenu("Plugins");
        Vector<String> pluginsVector = GenericObjectEditor.getClassnames(VisualizePlugin.class.getName());
        boolean availablePlugins = false;
        for (int i = 0; i < pluginsVector.size(); ++i) {
            String className = pluginsVector.elementAt(i);
            try {
                VisualizePlugin plugin = (VisualizePlugin)Class.forName(className).newInstance();
                if (plugin == null) continue;
                availablePlugins = true;
                JMenuItem pluginMenuItem = plugin.getVisualizeMenuItem(preds, classAtt);
                Version version = new Version();
                if (pluginMenuItem == null) continue;
                if (version.compareTo(plugin.getMinVersion()) < 0) {
                    pluginMenuItem.setText(pluginMenuItem.getText() + " (weka outdated)");
                }
                if (version.compareTo(plugin.getMaxVersion()) >= 0) {
                    pluginMenuItem.setText(pluginMenuItem.getText() + " (plugin outdated)");
                }
                visPlugins.add(pluginMenuItem);
                continue;
            }
            catch (ClassNotFoundException cnfe) {
                continue;
            }
            catch (InstantiationException ie) {
                continue;
            }
            catch (IllegalAccessException iae) {
                // empty catch block
            }
        }
        if (availablePlugins) {
            resultListMenu.add(visPlugins);
        }
        resultListMenu.show(this.m_History.getList(), x, y);
    }

    protected void visualizeTree(String dottyString, String treeName) {
        final JFrame jf = new JFrame("Weka Classifier Tree Visualizer: " + treeName);
        jf.setSize(500, 400);
        jf.getContentPane().setLayout(new BorderLayout());
        TreeVisualizer tv = new TreeVisualizer(null, dottyString, (NodePlace)new PlaceNode2());
        jf.getContentPane().add((Component)tv, "Center");
        jf.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                jf.dispose();
            }
        });
        jf.setVisible(true);
        tv.fitToScreen();
    }

    protected void visualizeBayesNet(String XMLBIF, String graphName) {
        final JFrame jf = new JFrame("Weka Classifier Graph Visualizer: " + graphName);
        jf.setSize(500, 400);
        jf.getContentPane().setLayout(new BorderLayout());
        GraphVisualizer gv = new GraphVisualizer();
        try {
            gv.readBIF(XMLBIF);
        }
        catch (BIFFormatException be) {
            System.err.println("unable to visualize BayesNet");
            be.printStackTrace();
        }
        gv.layoutGraph();
        jf.getContentPane().add((Component)gv, "Center");
        jf.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                jf.dispose();
            }
        });
        jf.setVisible(true);
    }

    protected void visualizeClassifierErrors(VisualizePanel sp) {
        if (sp != null) {
            String plotName = sp.getName();
            final JFrame jf = new JFrame("Weka Classifier Visualize: " + plotName);
            jf.setSize(600, 400);
            jf.getContentPane().setLayout(new BorderLayout());
            jf.getContentPane().add((Component)sp, "Center");
            jf.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    jf.dispose();
                }
            });
            jf.setVisible(true);
        }
    }

    protected void visualizeCostBenefitAnalysis(CostBenefitAnalysis cb, String classifierAndRelationName) {
        if (cb != null) {
            String windowTitle = "Weka Classifier: Cost/Benefit Analysis ";
            if (classifierAndRelationName != null) {
                windowTitle = windowTitle + "- " + classifierAndRelationName;
            }
            final JFrame jf = new JFrame(windowTitle);
            jf.setSize(1000, 600);
            jf.getContentPane().setLayout(new BorderLayout());
            jf.getContentPane().add((Component)cb, "Center");
            jf.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    jf.dispose();
                }
            });
            jf.setVisible(true);
        }
    }

    protected void saveBuffer(String name) {
        StringBuffer sb = this.m_History.getNamedBuffer(name);
        if (sb != null && this.m_SaveOut.save(sb)) {
            this.m_Log.logMessage("Save successful.");
        }
    }

    protected void stopClassifier() {
        if (this.m_RunThread != null) {
            this.m_RunThread.interrupt();
            this.m_RunThread.stop();
        }
    }

    protected void saveClassifier(String name, Classifier classifier, Instances trainHeader) {
        File sFile = null;
        boolean saveOK = true;
        int returnVal = this.m_FileChooser.showSaveDialog(this);
        if (returnVal == 0) {
            sFile = this.m_FileChooser.getSelectedFile();
            if (!sFile.getName().toLowerCase().endsWith(MODEL_FILE_EXTENSION)) {
                sFile = new File(sFile.getParent(), sFile.getName() + MODEL_FILE_EXTENSION);
            }
            this.m_Log.statusMessage("Saving model to file...");
            try {
                OutputStream os = new FileOutputStream(sFile);
                if (sFile.getName().endsWith(".gz")) {
                    os = new GZIPOutputStream(os);
                }
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(os);
                objectOutputStream.writeObject(classifier);
                if (trainHeader != null) {
                    objectOutputStream.writeObject(trainHeader);
                }
                objectOutputStream.flush();
                objectOutputStream.close();
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, e, "Save Failed", 0);
                saveOK = false;
            }
            if (saveOK) {
                this.m_Log.logMessage("Saved model (" + name + ") to file '" + sFile.getName() + "'");
            }
            this.m_Log.statusMessage("OK");
        }
    }

    protected void loadClassifier() {
        int returnVal = this.m_FileChooser.showOpenDialog(this);
        if (returnVal == 0) {
            Instances trainHeader;
            Classifier classifier;
            File selected;
            block21: {
                selected = this.m_FileChooser.getSelectedFile();
                classifier = null;
                trainHeader = null;
                this.m_Log.statusMessage("Loading model from file...");
                try {
                    InputStream is = new FileInputStream(selected);
                    if (selected.getName().endsWith(PMML_FILE_EXTENSION)) {
                        PMMLModel model = PMMLFactory.getPMMLModel(is, this.m_Log);
                        if (model instanceof PMMLClassifier) {
                            classifier = (PMMLClassifier)model;
                            break block21;
                        }
                        throw new Exception("PMML model is not a classification/regression model!");
                    }
                    if (selected.getName().endsWith(".gz")) {
                        is = new GZIPInputStream(is);
                    }
                    ObjectInputStream objectInputStream = new ObjectInputStream(is);
                    classifier = (Classifier)objectInputStream.readObject();
                    try {
                        trainHeader = (Instances)objectInputStream.readObject();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    objectInputStream.close();
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(null, e, "Load Failed", 0);
                }
            }
            this.m_Log.statusMessage("OK");
            if (classifier != null) {
                this.m_Log.logMessage("Loaded model from file '" + selected.getName() + "'");
                String name = new SimpleDateFormat("HH:mm:ss - ").format(new Date());
                String cname = classifier.getClass().getName();
                if (cname.startsWith("weka.classifiers.")) {
                    cname = cname.substring("weka.classifiers.".length());
                }
                name = name + cname + " from file '" + selected.getName() + "'";
                StringBuffer outBuff = new StringBuffer();
                outBuff.append("=== Model information ===\n\n");
                outBuff.append("Filename:     " + selected.getName() + "\n");
                outBuff.append("Scheme:       " + classifier.getClass().getName());
                if (classifier instanceof OptionHandler) {
                    String[] o = classifier.getOptions();
                    outBuff.append(" " + Utils.joinOptions(o));
                }
                outBuff.append("\n");
                if (trainHeader != null) {
                    outBuff.append("Relation:     " + trainHeader.relationName() + '\n');
                    outBuff.append("Attributes:   " + trainHeader.numAttributes() + '\n');
                    if (trainHeader.numAttributes() < 100) {
                        for (int i = 0; i < trainHeader.numAttributes(); ++i) {
                            outBuff.append("              " + trainHeader.attribute(i).name() + '\n');
                        }
                    } else {
                        outBuff.append("              [list of attributes omitted]\n");
                    }
                } else {
                    outBuff.append("\nTraining data unknown\n");
                }
                outBuff.append("\n=== Classifier model ===\n\n");
                outBuff.append(classifier.toString() + "\n");
                this.m_History.addResult(name, outBuff);
                this.m_History.setSingle(name);
                FastVector vv = new FastVector();
                vv.addElement(classifier);
                if (trainHeader != null) {
                    vv.addElement(trainHeader);
                }
                String grph = null;
                if (classifier instanceof Drawable) {
                    try {
                        grph = ((Drawable)((Object)classifier)).graph();
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                if (grph != null) {
                    vv.addElement(grph);
                }
                this.m_History.addObject(name, vv);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reevaluateModel(final String name, final Classifier classifier, final Instances trainHeader) {
        if (this.m_RunThread == null) {
            ClassifierPanel classifierPanel = this;
            synchronized (classifierPanel) {
                this.m_StartBut.setEnabled(false);
                this.m_StopBut.setEnabled(true);
            }
            this.m_RunThread = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Loose catch block
                 */
                public void run() {
                    block83: {
                        Evaluation eval;
                        String grph;
                        boolean saveVis;
                        Instances predInstances;
                        FastVector plotSize;
                        FastVector plotShape;
                        Instances userTestStructure;
                        block76: {
                            ClassifierPanel.this.m_Log.statusMessage("Setting up...");
                            StringBuffer outBuff = ClassifierPanel.this.m_History.getNamedBuffer(name);
                            ConverterUtils.DataSource source = null;
                            userTestStructure = null;
                            plotShape = new FastVector();
                            plotSize = new FastVector();
                            predInstances = null;
                            CostMatrix costMatrix = null;
                            if (ClassifierPanel.this.m_EvalWRTCostsBut.isSelected()) {
                                costMatrix = new CostMatrix((CostMatrix)ClassifierPanel.this.m_CostMatrixEditor.getValue());
                            }
                            boolean outputConfusion = ClassifierPanel.this.m_OutputConfusionBut.isSelected();
                            boolean outputPerClass = ClassifierPanel.this.m_OutputPerClassBut.isSelected();
                            boolean outputSummary = true;
                            boolean outputEntropy = ClassifierPanel.this.m_OutputEntropyBut.isSelected();
                            saveVis = ClassifierPanel.this.m_StorePredictionsBut.isSelected();
                            boolean outputPredictionsText = ClassifierPanel.this.m_OutputPredictionsTextBut.isSelected();
                            grph = null;
                            eval = null;
                            boolean incrementalLoader = ClassifierPanel.this.m_TestLoader instanceof IncrementalConverter;
                            if (ClassifierPanel.this.m_TestLoader != null && ClassifierPanel.this.m_TestLoader.getStructure() != null) {
                                ClassifierPanel.this.m_TestLoader.reset();
                                source = new ConverterUtils.DataSource(ClassifierPanel.this.m_TestLoader);
                                userTestStructure = source.getStructure();
                            }
                            if (source == null) {
                                throw new Exception("No user test set has been specified");
                            }
                            if (trainHeader != null) {
                                if (trainHeader.classIndex() > userTestStructure.numAttributes() - 1) {
                                    throw new Exception("Train and test set are not compatible");
                                }
                                userTestStructure.setClassIndex(trainHeader.classIndex());
                                if (!trainHeader.equalHeaders(userTestStructure)) {
                                    throw new Exception("Train and test set are not compatible");
                                }
                            } else if (classifier instanceof PMMLClassifier) {
                                Instances miningSchemaStructure = ((PMMLClassifier)classifier).getMiningSchema().getMiningSchemaAsInstances();
                                String className = miningSchemaStructure.classAttribute().name();
                                Attribute classMatch = userTestStructure.attribute(className);
                                if (classMatch == null) {
                                    throw new Exception("Can't find a match for the PMML target field " + className + " in the " + "test instances!");
                                }
                                userTestStructure.setClass(classMatch);
                            } else {
                                userTestStructure.setClassIndex(userTestStructure.numAttributes() - 1);
                            }
                            if (ClassifierPanel.this.m_Log instanceof TaskLogger) {
                                ((TaskLogger)((Object)ClassifierPanel.this.m_Log)).taskStarted();
                            }
                            ClassifierPanel.this.m_Log.statusMessage("Evaluating on test data...");
                            ClassifierPanel.this.m_Log.logMessage("Re-evaluating classifier (" + name + ") on test set");
                            eval = new Evaluation(userTestStructure, costMatrix);
                            eval.useNoPriors();
                            if (saveVis) {
                                predInstances = ClassifierPanel.setUpVisualizableInstances(userTestStructure);
                                predInstances.setClassIndex(userTestStructure.classIndex() + 1);
                            }
                            outBuff.append("\n=== Re-evaluation on test set ===\n\n");
                            outBuff.append("User supplied test set\n");
                            outBuff.append("Relation:     " + userTestStructure.relationName() + '\n');
                            if (incrementalLoader) {
                                outBuff.append("Instances:     unknown (yet). Reading incrementally\n");
                            } else {
                                outBuff.append("Instances:    " + source.getDataSet().numInstances() + "\n");
                            }
                            outBuff.append("Attributes:   " + userTestStructure.numAttributes() + "\n\n");
                            if (trainHeader == null) {
                                outBuff.append("NOTE - if test set is not compatible then results are unpredictable\n\n");
                            }
                            if (outputPredictionsText) {
                                outBuff.append("=== Predictions on test set ===\n\n");
                                outBuff.append(" inst#,    actual, predicted, error");
                                if (userTestStructure.classAttribute().isNominal()) {
                                    outBuff.append(", probability distribution");
                                }
                                outBuff.append("\n");
                            }
                            int jj = 0;
                            while (source.hasMoreElements(userTestStructure)) {
                                Instance instance = source.nextElement(userTestStructure);
                                ClassifierPanel.processClassifierPrediction(instance, classifier, eval, predInstances, plotShape, plotSize);
                                if (outputPredictionsText) {
                                    outBuff.append(ClassifierPanel.this.predictionText(classifier, instance, jj + 1));
                                }
                                if (++jj % 100 != 0) continue;
                                ClassifierPanel.this.m_Log.statusMessage("Evaluating on test data. Processed " + jj + " instances...");
                            }
                            if (outputPredictionsText) {
                                outBuff.append("\n");
                            }
                            if (outputSummary) {
                                outBuff.append(eval.toSummaryString(outputEntropy) + "\n");
                            }
                            if (userTestStructure.classAttribute().isNominal()) {
                                if (outputPerClass) {
                                    outBuff.append(eval.toClassDetailsString() + "\n");
                                }
                                if (outputConfusion) {
                                    outBuff.append(eval.toMatrixString() + "\n");
                                }
                            }
                            ClassifierPanel.this.m_History.updateResult(name);
                            ClassifierPanel.this.m_Log.logMessage("Finished re-evaluation");
                            ClassifierPanel.this.m_Log.statusMessage("OK");
                            Object var21_22 = null;
                            try {
                                FastVector vv;
                                if (classifier instanceof PMMLClassifier) {
                                    ((PMMLClassifier)classifier).done();
                                }
                                if (predInstances == null || predInstances.numInstances() <= 0) break block76;
                                if (predInstances.attribute(predInstances.classIndex()).isNumeric()) {
                                    ClassifierPanel.this.postProcessPlotInfo(plotSize);
                                }
                                ClassifierPanel.this.m_CurrentVis = new VisualizePanel();
                                ClassifierPanel.this.m_CurrentVis.setName(name + " (" + userTestStructure.relationName() + ")");
                                ClassifierPanel.this.m_CurrentVis.setLog(ClassifierPanel.this.m_Log);
                                PlotData2D tempd = new PlotData2D(predInstances);
                                tempd.setShapeSize(plotSize);
                                tempd.setShapeType(plotShape);
                                tempd.setPlotName(name + " (" + userTestStructure.relationName() + ")");
                                ClassifierPanel.this.m_CurrentVis.addPlot(tempd);
                                ClassifierPanel.this.m_CurrentVis.setColourIndex(predInstances.classIndex());
                                if (classifier instanceof Drawable) {
                                    try {
                                        grph = ((Drawable)((Object)classifier)).graph();
                                    }
                                    catch (Exception ex2) {
                                        // empty catch block
                                    }
                                }
                                if (saveVis) {
                                    vv = new FastVector();
                                    vv.addElement(classifier);
                                    if (trainHeader != null) {
                                        vv.addElement(trainHeader);
                                    }
                                    vv.addElement(ClassifierPanel.this.m_CurrentVis);
                                    if (grph != null) {
                                        vv.addElement(grph);
                                    }
                                    if (eval != null && eval.predictions() != null) {
                                        vv.addElement(eval.predictions());
                                        vv.addElement(userTestStructure.classAttribute());
                                    }
                                    ClassifierPanel.this.m_History.addObject(name, vv);
                                } else {
                                    vv = new FastVector();
                                    vv.addElement(classifier);
                                    if (trainHeader != null) {
                                        vv.addElement(trainHeader);
                                    }
                                    ClassifierPanel.this.m_History.addObject(name, vv);
                                }
                            }
                            catch (Exception ex3) {
                                ex3.printStackTrace();
                            }
                        }
                        if (this.isInterrupted()) {
                            ClassifierPanel.this.m_Log.logMessage("Interrupted reevaluate model");
                            ClassifierPanel.this.m_Log.statusMessage("Interrupted");
                        }
                        35 var22_25 = this;
                        synchronized (var22_25) {
                            ClassifierPanel.this.m_StartBut.setEnabled(true);
                            ClassifierPanel.this.m_StopBut.setEnabled(false);
                            ClassifierPanel.this.m_RunThread = null;
                        }
                        if (ClassifierPanel.this.m_Log instanceof TaskLogger) {
                            ((TaskLogger)((Object)ClassifierPanel.this.m_Log)).taskFinished();
                        }
                        break block83;
                        {
                            catch (Exception ex) {
                                block79: {
                                    ex.printStackTrace();
                                    ClassifierPanel.this.m_Log.logMessage(ex.getMessage());
                                    ClassifierPanel.this.m_Log.statusMessage("See error log");
                                    ex.printStackTrace();
                                    ClassifierPanel.this.m_Log.logMessage(ex.getMessage());
                                    JOptionPane.showMessageDialog(ClassifierPanel.this, "Problem evaluationg classifier:\n" + ex.getMessage(), "Evaluate classifier", 0);
                                    ClassifierPanel.this.m_Log.statusMessage("Problem evaluating classifier");
                                    Object var21_23 = null;
                                    try {
                                        FastVector vv;
                                        if (classifier instanceof PMMLClassifier) {
                                            ((PMMLClassifier)classifier).done();
                                        }
                                        if (predInstances == null || predInstances.numInstances() <= 0) break block79;
                                        if (predInstances.attribute(predInstances.classIndex()).isNumeric()) {
                                            ClassifierPanel.this.postProcessPlotInfo(plotSize);
                                        }
                                        ClassifierPanel.this.m_CurrentVis = new VisualizePanel();
                                        ClassifierPanel.this.m_CurrentVis.setName(name + " (" + userTestStructure.relationName() + ")");
                                        ClassifierPanel.this.m_CurrentVis.setLog(ClassifierPanel.this.m_Log);
                                        PlotData2D tempd = new PlotData2D(predInstances);
                                        tempd.setShapeSize(plotSize);
                                        tempd.setShapeType(plotShape);
                                        tempd.setPlotName(name + " (" + userTestStructure.relationName() + ")");
                                        ClassifierPanel.this.m_CurrentVis.addPlot(tempd);
                                        ClassifierPanel.this.m_CurrentVis.setColourIndex(predInstances.classIndex());
                                        if (classifier instanceof Drawable) {
                                            try {
                                                grph = ((Drawable)((Object)classifier)).graph();
                                            }
                                            catch (Exception ex2) {
                                                // empty catch block
                                            }
                                        }
                                        if (saveVis) {
                                            vv = new FastVector();
                                            vv.addElement(classifier);
                                            if (trainHeader != null) {
                                                vv.addElement(trainHeader);
                                            }
                                            vv.addElement(ClassifierPanel.this.m_CurrentVis);
                                            if (grph != null) {
                                                vv.addElement(grph);
                                            }
                                            if (eval != null && eval.predictions() != null) {
                                                vv.addElement(eval.predictions());
                                                vv.addElement(userTestStructure.classAttribute());
                                            }
                                            ClassifierPanel.this.m_History.addObject(name, vv);
                                        } else {
                                            vv = new FastVector();
                                            vv.addElement(classifier);
                                            if (trainHeader != null) {
                                                vv.addElement(trainHeader);
                                            }
                                            ClassifierPanel.this.m_History.addObject(name, vv);
                                        }
                                    }
                                    catch (Exception ex3) {
                                        ex3.printStackTrace();
                                    }
                                }
                                if (this.isInterrupted()) {
                                    ClassifierPanel.this.m_Log.logMessage("Interrupted reevaluate model");
                                    ClassifierPanel.this.m_Log.statusMessage("Interrupted");
                                }
                                35 var22_26 = this;
                                synchronized (var22_26) {
                                    ClassifierPanel.this.m_StartBut.setEnabled(true);
                                    ClassifierPanel.this.m_StopBut.setEnabled(false);
                                    ClassifierPanel.this.m_RunThread = null;
                                }
                                if (ClassifierPanel.this.m_Log instanceof TaskLogger) {
                                    ((TaskLogger)((Object)ClassifierPanel.this.m_Log)).taskFinished();
                                }
                            }
                        }
                        catch (Throwable throwable) {
                            block82: {
                                Object var21_24 = null;
                                try {
                                    FastVector vv;
                                    if (classifier instanceof PMMLClassifier) {
                                        ((PMMLClassifier)classifier).done();
                                    }
                                    if (predInstances == null || predInstances.numInstances() <= 0) break block82;
                                    if (predInstances.attribute(predInstances.classIndex()).isNumeric()) {
                                        ClassifierPanel.this.postProcessPlotInfo(plotSize);
                                    }
                                    ClassifierPanel.this.m_CurrentVis = new VisualizePanel();
                                    ClassifierPanel.this.m_CurrentVis.setName(name + " (" + userTestStructure.relationName() + ")");
                                    ClassifierPanel.this.m_CurrentVis.setLog(ClassifierPanel.this.m_Log);
                                    PlotData2D tempd = new PlotData2D(predInstances);
                                    tempd.setShapeSize(plotSize);
                                    tempd.setShapeType(plotShape);
                                    tempd.setPlotName(name + " (" + userTestStructure.relationName() + ")");
                                    ClassifierPanel.this.m_CurrentVis.addPlot(tempd);
                                    ClassifierPanel.this.m_CurrentVis.setColourIndex(predInstances.classIndex());
                                    if (classifier instanceof Drawable) {
                                        try {
                                            grph = ((Drawable)((Object)classifier)).graph();
                                        }
                                        catch (Exception ex2) {
                                            // empty catch block
                                        }
                                    }
                                    if (saveVis) {
                                        vv = new FastVector();
                                        vv.addElement(classifier);
                                        if (trainHeader != null) {
                                            vv.addElement(trainHeader);
                                        }
                                        vv.addElement(ClassifierPanel.this.m_CurrentVis);
                                        if (grph != null) {
                                            vv.addElement(grph);
                                        }
                                        if (eval != null && eval.predictions() != null) {
                                            vv.addElement(eval.predictions());
                                            vv.addElement(userTestStructure.classAttribute());
                                        }
                                        ClassifierPanel.this.m_History.addObject(name, vv);
                                    } else {
                                        vv = new FastVector();
                                        vv.addElement(classifier);
                                        if (trainHeader != null) {
                                            vv.addElement(trainHeader);
                                        }
                                        ClassifierPanel.this.m_History.addObject(name, vv);
                                    }
                                }
                                catch (Exception ex3) {
                                    ex3.printStackTrace();
                                }
                            }
                            if (this.isInterrupted()) {
                                ClassifierPanel.this.m_Log.logMessage("Interrupted reevaluate model");
                                ClassifierPanel.this.m_Log.statusMessage("Interrupted");
                            }
                            35 var22_27 = this;
                            synchronized (var22_27) {
                                ClassifierPanel.this.m_StartBut.setEnabled(true);
                                ClassifierPanel.this.m_StopBut.setEnabled(false);
                                ClassifierPanel.this.m_RunThread = null;
                            }
                            if (ClassifierPanel.this.m_Log instanceof TaskLogger) {
                                ((TaskLogger)((Object)ClassifierPanel.this.m_Log)).taskFinished();
                            }
                            throw throwable;
                        }
                    }
                }
            };
            this.m_RunThread.setPriority(1);
            this.m_RunThread.start();
        }
    }

    protected void updateCapabilitiesFilter(Capabilities filter) {
        Capabilities filterClass;
        if (filter == null) {
            this.m_ClassifierEditor.setCapabilitiesFilter(new Capabilities(null));
            return;
        }
        Instances tempInst = !ExplorerDefaults.getInitGenericObjectEditorFilter() ? new Instances(this.m_Instances, 0) : new Instances(this.m_Instances);
        tempInst.setClassIndex(this.m_ClassCombo.getSelectedIndex());
        try {
            filterClass = Capabilities.forInstances(tempInst);
        }
        catch (Exception e) {
            filterClass = new Capabilities(null);
        }
        this.m_ClassifierEditor.setCapabilitiesFilter(filterClass);
        this.m_StartBut.setEnabled(true);
        Capabilities currentFilter = this.m_ClassifierEditor.getCapabilitiesFilter();
        Classifier classifier = (Classifier)this.m_ClassifierEditor.getValue();
        Capabilities currentSchemeCapabilities = null;
        if (classifier != null && currentFilter != null && classifier instanceof CapabilitiesHandler && !(currentSchemeCapabilities = classifier.getCapabilities()).supportsMaybe(currentFilter) && !currentSchemeCapabilities.supports(currentFilter)) {
            this.m_StartBut.setEnabled(false);
        }
    }

    public void capabilitiesFilterChanged(Explorer.CapabilitiesFilterChangeEvent e) {
        if (e.getFilter() == null) {
            this.updateCapabilitiesFilter(null);
        } else {
            this.updateCapabilitiesFilter((Capabilities)e.getFilter().clone());
        }
    }

    public void setExplorer(Explorer parent) {
        this.m_Explorer = parent;
    }

    public Explorer getExplorer() {
        return this.m_Explorer;
    }

    public String getTabTitle() {
        return "Classify";
    }

    public String getTabTitleToolTip() {
        return "Classify instances";
    }

    public static void main(String[] args) {
        try {
            final JFrame jf = new JFrame("Weka Explorer: Classifier");
            jf.getContentPane().setLayout(new BorderLayout());
            ClassifierPanel sp = new ClassifierPanel();
            jf.getContentPane().add((Component)sp, "Center");
            LogPanel lp = new LogPanel();
            sp.setLog(lp);
            jf.getContentPane().add((Component)lp, "South");
            jf.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    jf.dispose();
                    System.exit(0);
                }
            });
            jf.pack();
            jf.setSize(800, 600);
            jf.setVisible(true);
            if (args.length == 1) {
                System.err.println("Loading instances from " + args[0]);
                BufferedReader r = new BufferedReader(new FileReader(args[0]));
                Instances i = new Instances(r);
                sp.setInstances(i);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.err.println(ex.getMessage());
        }
    }

    static {
        GenericObjectEditor.registerEditors();
    }
}

