package jp.hasc.hasctool.core.runtime.filter.weka.label;

import jp.hasc.hasctool.core.runtime.RuntimeContext;

/**
 * labelを修正するフィルタです
 * 入力はfilePath,label
 * 出力はfilePath,状態
 * sampleNum_の数、同じラベルが続くと状態遷移をします
 * @author hiro
 */
public class LPModifier extends LabelModifier{

	int sampleNum_;
	int count_;
	boolean start_;
	String state_;

	@Override
	public void setup(RuntimeContext context) {
		super.setup(context);
		count_ = 0;
		start_ = true;
	}

	public void setSampleNum(int num){
		sampleNum_ = num;
	}

	String modify(String label){
		if(start_){
			start_ = false;
			state_ = label;
		}else{
			if(label.equals(state_)){
				count_ = 0;
			}else{
				count_++;
				if(count_ == sampleNum_){
					state_ = label;
					count_ = 0;
				}
			}
		}
		return state_;
	}
}
