// based on GEF ShapesEditor example
/*******************************************************************************
 * Copyright (c) 2004, 2005 Elias Volanakis and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Elias Volanakis - initial API and implementation
 *******************************************************************************/
package jp.hasc.hasctool.ui.bdeditor2.parts;

import jp.hasc.hasctool.ui.bdeditor2.model.BlockDiagramElement;
import jp.hasc.hasctool.ui.bdeditor2.model.BlockElement;
import jp.hasc.hasctool.ui.bdeditor2.model.ShapeElement;
import jp.hasc.hasctool.ui.bdeditor2.model.commands.BlockCreateCommand;
import jp.hasc.hasctool.ui.bdeditor2.model.commands.BlockSetConstraintCommand;
import jp.hasc.hasctool.ui.bdeditor2.model.commands.ShapeCreateCommand;
import jp.hasc.hasctool.ui.bdeditor2.model.commands.ShapeSetConstraintCommand;

import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.ResizableEditPolicy;
import org.eclipse.gef.editpolicies.XYLayoutEditPolicy;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.CreateRequest;

/**
 * @author iwasaki
 */
public class DiagramXYLayoutEditPolicy extends XYLayoutEditPolicy {

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * ConstrainedLayoutEditPolicy#createChangeConstraintCommand(ChangeBoundsRequest
	 * , EditPart, Object)
	 */
	protected Command createChangeConstraintCommand(
			ChangeBoundsRequest request, EditPart child, Object constraint) {
		Object m = child.getModel();
		if (child instanceof BlockEditPart && constraint instanceof Rectangle) {
			// return a command that can move and/or resize a Shape
			return new BlockSetConstraintCommand((BlockElement)m, request, (Rectangle) constraint);
		} else if (m instanceof ShapeElement && constraint instanceof Rectangle) {
			// return a command that can move and/or resize a Shape
			return new ShapeSetConstraintCommand((ShapeElement)m, request, (Rectangle) constraint);
		}
		return super.createChangeConstraintCommand(request, child, constraint);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see ConstrainedLayoutEditPolicy#createChangeConstraintCommand(EditPart,
	 * Object)
	 */
	protected Command createChangeConstraintCommand(EditPart child,
			Object constraint) {
		// not used in this example
		return null;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see LayoutEditPolicy#getCreateCommand(CreateRequest)
	 */
	protected Command getCreateCommand(CreateRequest request) {
		Class<?> childClass = (Class<?>)request.getNewObjectType();
		
		if (BlockElement.class.isAssignableFrom(childClass)) {
			return new BlockCreateCommand(this,
					(BlockElement) request.getNewObject(),
					(BlockDiagramElement) getHost().getModel(),
					(Rectangle) getConstraintFor(request));
		}else if (ShapeElement.class.isAssignableFrom(childClass)) {
			return new ShapeCreateCommand(
					(ShapeElement) request.getNewObject(),
					(BlockDiagramElement) getHost().getModel(),
					(Rectangle) getConstraintFor(request));
		}
		
		return null;
	}

	@Override
	protected EditPolicy createChildEditPolicy(EditPart child) {
		if (child instanceof BlockEditPart) {
			ResizableEditPolicy policy = new ResizableEditPolicy();
			policy.setResizeDirections(0); // fixed size
			return policy;
		}

		// default
		return super.createChildEditPolicy(child);
	}

}