package jp.hasc.hasctool.core.test;

import java.util.Arrays;

import jp.hasc.hasctool.core.util.CSVUtil;
import junit.framework.TestCase;

/**
 * @author iwasaki
 */
public class CSVUtilTest extends TestCase {
	public void test1() {
		String[] ret = CSVUtil.parseCSVRecord("1,2,3");
		assertTrue(Arrays.equals(new String[]{"1","2","3"}, ret));
	}
	public void test2() {
		String[] ret = CSVUtil.parseCSVRecord("1,2,3,");
		assertTrue(Arrays.equals(new String[]{"1","2","3",""}, ret));
	}
	public void test3() {
		String[] ret = CSVUtil.parseCSVRecord(",1,,2");
		assertTrue(Arrays.equals(new String[]{"","1","","2"}, ret));
	}
	public void test4() {
		String[] ret = CSVUtil.parseCSVRecord("");
		assertTrue(Arrays.equals(new String[]{""}, ret));
	}
	public void test5() {
		String[] ret = CSVUtil.parseCSVRecord(",");
		assertTrue(Arrays.equals(new String[]{"",""}, ret));
	}
}
