package jp.hasc.hasctool.core.runtime.filter.window;

/**
 * AbstractFilterを使ったフィルタ
 * ベクトルの各要素に対してGaussian窓を適用する
 * @author hiro, iwasaki
 */
public class GaussianWindowFunctionFilter extends AbstractWindowFunctionFilter {

	double coefficient;
	
	public double[] windowFunction(double[] input, int index){
		int N = input.length;
		double[] newValue = new double[N];
		double K = coefficient;
		for(int n=0; n<N; n++){
			int m = (n+index)%N;
			double val1 = Math.pow( n-(N-1)/2, 2.0 );
			double val2 = -2.0*K*K / Math.pow((N-1), 2.0);
			double val = Math.exp(val1*val2);
			newValue[n] = input[m] * val;
		}
		
		return newValue;
	}

	public void setCoefficient(double coefficient) {
		this.coefficient = coefficient;
	}
			
}
