package jp.hasc.hasctool.core.runtime.filter.file;

import jp.hasc.hasctool.core.data.SignalMessage;
import jp.hasc.hasctool.core.data.VectorSignalMessage;
import jp.hasc.hasctool.core.runtime.filter.AbstractFilter;

/**
 * VectorSignalMessageを、CSVの文字列系列として出力するフィルタです
 * @author iwasaki
 */
public class VectorToCSVFilter extends AbstractFilter {

	@Override
	public void processMessage(Object message) throws InterruptedException {
		if (message instanceof VectorSignalMessage) {
			VectorSignalMessage sig = (VectorSignalMessage) message;
			StringBuilder sb=new StringBuilder();
			// 最初に時刻
			sb.append(SignalMessage.TIME_UNIT.toMicros(sig.getTime())/1000000.0);
			// 続いてVector要素
			for(int i=0,num=sig.getVectorSize(); i<num; ++i) {
				sb.append(",");
				sb.append(sig.getVectorElement(i));
			}
			// output
			outputMessage(sb.toString());
		}else if (message instanceof SignalMessage) {
			// NOP
		}else{
			outputMessage(message);
		}
	}
}
