package jp.hasc.hasctool.core.data;

import java.util.Arrays;

/**
 * VectorSignalMessageの実装（複素数版）です
 * @author hiro
 */
public class ComplexVectorSignalMessage extends AbstractSignalMessage implements VectorSignalMessage {
	
	private Complex[] vectorValue_;
	
	public ComplexVectorSignalMessage(long time, Complex[] vectorValue, boolean cloneVectorValue) {
		super(time);
		if (cloneVectorValue) { vectorValue = vectorValue.clone(); }
		vectorValue_=vectorValue;
	}
	
	public Complex getVectorValue(int index){
	  return new Complex(vectorValue_[index].re(), vectorValue_[index].im());
	}

	@Override
	public double getVectorElement(int index) {
		return vectorValue_[index].abs();
	}
	
	@Override
	public double getVectorNorm() {
		double sum = 0;
		for(int i=0; i<vectorValue_.length; i++){
			double element = vectorValue_[i].abs();
			sum += element*element;
		}
		return Math.sqrt(sum);
	}

	@Override
	public int getVectorSize() {
		return vectorValue_.length;
	}
	
	@Override
	public SignalMessage createDelayedElement(long delay) {
		if (delay==0) return this;
		return new ComplexVectorSignalMessage(getTime()+delay, vectorValue_, false);
	}
	
	@Override
	public String toString() {
		return "{time:"+getTime()+", value:"+Arrays.toString(vectorValue_)+"}";
	}

	/** auto generated */
	@Override
	public int hashCode() {
		final int prime = 31;
		int result = super.hashCode();
		result = prime * result + Arrays.hashCode(vectorValue_);
		return result;
	}

	/** auto generated */
	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (!super.equals(obj))
			return false;
		if (getClass() != obj.getClass())
			return false;
		ComplexVectorSignalMessage other = (ComplexVectorSignalMessage) obj;
		if (!Arrays.equals(vectorValue_, other.vectorValue_))
			return false;
		return true;
	}

}
