/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.servlet;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.io.nio.DirectNIOBuffer;
import org.eclipse.jetty.io.nio.IndirectNIOBuffer;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpConnection;
import org.eclipse.jetty.server.ResourceCache;
import org.eclipse.jetty.server.nio.NIOConnector;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.resource.Resource;

class NIOResourceCache
extends ResourceCache {
    boolean _useFileMappedBuffer;

    public NIOResourceCache(MimeTypes mimeTypes) {
        super(mimeTypes);
    }

    protected void fill(ResourceCache.Content content) throws IOException {
        DirectNIOBuffer buffer = null;
        Resource resource = content.getResource();
        long length = resource.length();
        if (this._useFileMappedBuffer && resource.getFile() != null) {
            buffer = new DirectNIOBuffer(resource.getFile());
        } else {
            InputStream is = resource.getInputStream();
            try {
                Connector connector = HttpConnection.getCurrentConnection().getConnector();
                buffer = ((NIOConnector)connector).getUseDirectBuffers() ? new DirectNIOBuffer((int)length) : new IndirectNIOBuffer((int)length);
            }
            catch (OutOfMemoryError e) {
                Log.warn((String)e.toString());
                Log.debug((Throwable)e);
                buffer = new IndirectNIOBuffer((int)length);
            }
            buffer.readFrom(is, (int)length);
            is.close();
        }
        content.setBuffer((Buffer)buffer);
    }

    public boolean isUseFileMappedBuffer() {
        return this._useFileMappedBuffer;
    }

    public void setUseFileMappedBuffer(boolean useFileMappedBuffer) {
        this._useFileMappedBuffer = useFileMappedBuffer;
    }
}

