﻿Option Strict On
Option Explicit On

Imports System.Runtime.InteropServices
Imports System.Text

Public Module SellApis
    Public Const SHGFI_ICON As Integer = &H100
    Public Const SHGFI_LARGEICON As Integer = &H0
    Public Const SHGFI_SMALLICON As Integer = &H1
    Public Const SHIL_JUMBO As Integer = &H4
    Public Const SHIL_EXTRALARGE As Integer = &H2

    <DllImport("shell32.dll", CharSet:=CharSet.Auto)> _
    Public Function SHGetFileInfo(
            ByVal pszPath As String,
            ByVal dwFileAttributes As Integer,
            ByRef psfi As ShFileInfo,
            ByVal cbSizeFileInfo As Integer,
            ByVal uFlags As Integer) As Integer
    End Function

    <DllImport("kernel32.dll")> _
    Public Function CloseHandle(ByVal handle As IntPtr) As Boolean
    End Function

    <DllImport("shell32.dll")> _
    Public Function SHGetImageList(ByVal iImageList As Integer,
                                   ByRef riid As Guid,
                                   ByRef ppv As IImageList) As Integer
    End Function

    <DllImport("shell32.dll")> _
    Public Function SHGetSpecialFolderLocation(ByVal hwndOwner As IntPtr,
                                               ByRef nFolder As Int32,
                                               ByRef ppidl As IntPtr) As Integer
    End Function

    <DllImport("user32.dll")> _
    Public Function DestroyIcon(ByVal hIcon As IntPtr) As Integer
    End Function

    Public Function GetIcon(ByVal path As String, ByVal size As Integer) As ImageSource
        Dim hIcon As IntPtr = IntPtr.Zero
        Dim img As System.Drawing.Icon = Nothing

        Try
            Dim imgSource As ImageSource = Nothing
            Dim shinfo As New ShFileInfo
            SHGetFileInfo(path, 0, shinfo, Marshal.SizeOf(shinfo), SHGFI_ICON Or SHGFI_LARGEICON)

            Dim iidImageList As New Guid("46EB5926-582E-4017-9FDF-E8998DAA0950")
            Dim iml As IImageList = Nothing
            Dim hres As Integer = SHGetImageList(size, iidImageList, iml)

            If hres <> 0 Then
                Throw New ApplicationException("SHGetImageList Error: " + hres.ToString)
            End If

            hres = iml.GetIcon(shinfo.iIcon, 1, hIcon)
            If hres <> 0 Then
                Throw New ApplicationException("GetIcon Error: " + hres.ToString)
            End If

            img = System.Drawing.Icon.FromHandle(hIcon)
            imgSource = System.Windows.Interop.Imaging.CreateBitmapSourceFromHIcon(img.Handle,
                                                            Int32Rect.Empty,
                                                            BitmapSizeOptions.FromEmptyOptions())
            imgSource.Freeze()

            Return imgSource

        Catch ex As Exception
            Throw ex

        Finally
            If img IsNot Nothing Then img.Dispose()
            If hIcon <> IntPtr.Zero Then
                DestroyIcon(hIcon)
            End If
        End Try
    End Function

    <CLSCompliant(False), ComImport(), Guid("00021401-0000-0000-C000-000000000046")> _
    Public Class ShellLinkObject

    End Class

    <Flags()> _
    Public Enum SLGP
        SHORTPATH = &H1
        UNCPRIORITY = &H2
        RAWPATH = &H4
    End Enum

    <CLSCompliant(False), ComImport(), Guid("000214F9-0000-0000-C000-000000000046"), _
     InterfaceType(ComInterfaceType.InterfaceIsIUnknown)> _
    Public Interface IShellLink
        Sub GetPath(<MarshalAs(UnmanagedType.LPWStr)> ByVal pszFile As StringBuilder, ByVal cch As Integer, ByVal pfd As IntPtr, ByVal fFlags As SLGP)
        Sub _1() ' GetIDList
        Sub _2() ' SetIDList
        Sub _3() ' GetDescription
        Sub _4() ' SetDescription
        Sub _5() ' GetWorkingDirectory
        Function SetWorkingDirectory(<MarshalAs(UnmanagedType.LPWStr)> ByVal pszDir As String) As Integer
        Sub _7() ' GetArguments
        Function SetArguments(<MarshalAs(UnmanagedType.LPWStr)> ByVal pszArgs As String) As Integer
        Sub _9() ' GetHotkey
        Sub _10() ' SetHotkey
        Sub _11() ' GetShowCmd
        Sub _12() ' SetShowCmd
        Sub _13() ' GetIconLocation
        Sub _14() ' SetIconLocation
        Sub _15() ' SetRelativePath
        Sub _16() ' Resolve
        Function SetPath(<MarshalAs(UnmanagedType.LPWStr)> ByVal pszFile As String) As Integer
    End Interface

End Module
