/*
 * Decompiled with CFR 0.152.
 */
package jp.co.olympus.camerakit;

import android.annotation.SuppressLint;
import android.graphics.Rect;
import android.graphics.RectF;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import jp.co.olympus.camerakit.OLYCamera;
import jp.co.olympus.camerakit.rtpheader.d;
import jp.co.olympus.camerakit.rtpheader.e;
import jp.co.olympus.camerakit.rtpheader.f;
import jp.co.olympus.camerakit.rtpheader.g;
import jp.co.olympus.camerakit.rtpheader.h;
import jp.co.olympus.camerakit.rtpheader.k;
import jp.co.olympus.camerakit.rtpheader.l;
import jp.co.olympus.camerakit.rtpheader.m;
import jp.co.olympus.camerakit.rtpheader.n;
import jp.co.olympus.camerakit.rtpheader.o;
import jp.co.olympus.camerakit.rtpheader.p;
import jp.co.olympus.camerakit.rtpheader.q;
import jp.co.olympus.camerakit.rtpheader.r;

public class OLYCameraStatusTrait {
    private OLYCamera.k a;
    private String b;
    private String c;
    private boolean d;
    private int e;
    private int f;
    private int g;
    private boolean h;
    private boolean i;
    private long j;
    private int k;
    private double l;
    private String m;
    private double n;
    private double o;
    private double p;
    private String q;
    private double r;
    private double s;
    private double t;
    private String u;
    private double v;
    private double w;
    private double x;
    private String y;
    private double z;
    private boolean A;
    private boolean B;
    private boolean C;
    private Map<String, Object> D;
    private Map<String, RectF> E;
    private int F;

    protected OLYCameraStatusTrait(OLYCamera.k adapter) {
        if (adapter == null) {
            throw new NullPointerException();
        }
        if (!(adapter instanceof OLYCamera.k)) {
            throw new IllegalAccessError();
        }
        this.a = adapter;
    }

    public String getMediaMountStatus() {
        return this.b;
    }

    public String getLensMountStatus() {
        return this.c;
    }

    public boolean isHighTemperatureWarning() {
        return this.d;
    }

    public float getActualFocalLength() {
        return this.e;
    }

    public float getMinimumFocalLength() {
        return this.f;
    }

    public float getMaximumFocalLength() {
        return this.g;
    }

    public boolean isMediaBusy() {
        return this.h;
    }

    public boolean isMediaError() {
        return this.i;
    }

    public long getRemainingMediaCapacity() {
        return this.j;
    }

    public int getRemainingImageCapacity() {
        return this.k;
    }

    public double getRemainingVideoCapacity() {
        return this.l;
    }

    public String getActualApertureValue() {
        return this.m;
    }

    public double getCurrentApertureValue() {
        return this.n;
    }

    public double getMinimumApertureValue() {
        return this.o;
    }

    public double getMaximumApertureValue() {
        return this.p;
    }

    public String getActualShutterSpeed() {
        return this.q;
    }

    public double getCurrentShutterSpeed() {
        return this.r;
    }

    public double getMinimumShutterSpeed() {
        return this.s;
    }

    public double getMaximumShutterSpeed() {
        return this.t;
    }

    public String getActualExposureCompensation() {
        return this.u;
    }

    public double getCurrentExposureCompensation() {
        return this.v;
    }

    public double getMinimumExposureCompensation() {
        return this.w;
    }

    public double getMaximumExposureCompensation() {
        return this.x;
    }

    public String getActualIsoSensitivity() {
        return this.y;
    }

    public double getCurrentIsoSensitivity() {
        return this.z;
    }

    public boolean isActualIsoSensitivityWarning() {
        return this.A;
    }

    public boolean isExposureWarning() {
        return this.B;
    }

    public boolean isExposureMeteringWarning() {
        return this.C;
    }

    public int getLiveImageOrientation() {
        return this.F;
    }

    public Map<String, Object> getLevelGauge() {
        return this.D;
    }

    public Map<String, RectF> getDetectedHumanFaces() {
        return this.E;
    }

    public OLYCameraStatusTrait() {
        this.clearCameraStatus();
    }

    public void clearCameraStatus() {
        this.d = false;
        this.b = null;
        this.c = null;
        this.h = false;
        this.i = false;
        this.j = 0L;
        this.k = 0;
        this.l = 0.0;
        this.e = 0;
        this.f = 0;
        this.g = 0;
        this.clearCameraStatusForRecording();
    }

    public void clearCameraStatusForRecording() {
        this.m = null;
        this.n = Double.NaN;
        this.o = Double.NaN;
        this.p = Double.NaN;
        this.q = null;
        this.r = Double.NaN;
        this.s = Double.NaN;
        this.t = Double.NaN;
        this.u = null;
        this.v = Double.NaN;
        this.w = Double.NaN;
        this.x = Double.NaN;
        this.y = null;
        this.z = Double.NaN;
        this.A = false;
        this.B = false;
        this.C = false;
        this.F = -1;
    }

    @SuppressLint(value={"DefaultLocale"})
    public void updateWithRtpHeaderExtensions(Map<String, f> extensions) {
        q spiritLevel;
        l maxmovietime2;
        r zoominfo;
        e expphotowarning;
        k isospeedvalue;
        d expcomp;
        h focalvalue;
        p shutterspeedvalue;
        m maxtakenum;
        o rotation;
        n mntMediainfo = (n)extensions.get("mntmediainfo");
        if (mntMediainfo != null) {
            if (this.h != mntMediainfo.f()) {
                this.h = mntMediainfo.f();
                this.a.b("MediaBusy");
            }
            if (this.i != mntMediainfo.e()) {
                this.i = mntMediainfo.e();
                this.a.b("MediaError");
            }
        }
        if ((rotation = (o)extensions.get("rotation")) != null && this.F != rotation.a()) {
            this.F = rotation.a();
            this.a.b("LiveImageOrientation");
        }
        if ((maxtakenum = (m)extensions.get("maxtakenum")) != null) {
            int remainingRecordableImages = (int)maxtakenum.a();
            if (this.b == null || !this.b.equals("normal")) {
                remainingRecordableImages = 0;
            }
            if (this.k != remainingRecordableImages) {
                this.k = remainingRecordableImages;
                this.a.b("RemainingImageCapacity");
            }
        }
        if ((shutterspeedvalue = (p)extensions.get("shutspeedvalue")) != null) {
            String actualShutterSpeed;
            double currentShutterSpeed;
            double maximumShutterSpeed;
            boolean updateList = false;
            double minimumShutterSpeed = shutterspeedvalue.i() ? Double.NaN : (double)shutterspeedvalue.e() / (double)shutterspeedvalue.f();
            if (!(this.s == minimumShutterSpeed || Double.isNaN(this.s) && Double.isNaN(minimumShutterSpeed))) {
                this.s = minimumShutterSpeed;
                updateList = true;
            }
            if (!(this.t == (maximumShutterSpeed = shutterspeedvalue.i() ? Double.NaN : (double)shutterspeedvalue.b() / (double)shutterspeedvalue.c()) || Double.isNaN(this.t) && Double.isNaN(maximumShutterSpeed))) {
                this.t = maximumShutterSpeed;
                updateList = true;
            }
            if (updateList) {
                this.a.a("SHUTTER");
            }
            if (shutterspeedvalue.i()) {
                currentShutterSpeed = Double.NaN;
                actualShutterSpeed = null;
            } else {
                if (shutterspeedvalue.a() == p.a.b) {
                    currentShutterSpeed = (double)shutterspeedvalue.g() / (double)shutterspeedvalue.h();
                    actualShutterSpeed = currentShutterSpeed < 1.0 ? ((double)((int)(currentShutterSpeed = 1.0 / currentShutterSpeed)) == currentShutterSpeed ? String.format("%1.0f", currentShutterSpeed) : String.format("%1.1f", currentShutterSpeed)) : ((double)((int)currentShutterSpeed) == currentShutterSpeed ? String.format("%1.0f\"", currentShutterSpeed) : String.format("%1.1f\"", currentShutterSpeed));
                } else {
                    currentShutterSpeed = 0.0;
                    actualShutterSpeed = "0.0";
                }
                actualShutterSpeed = String.format("<%s/%s>", "SHUTTER", actualShutterSpeed);
            }
            if (!(this.r == currentShutterSpeed || Double.isNaN(this.r) && Double.isNaN(currentShutterSpeed))) {
                this.r = currentShutterSpeed;
                this.q = actualShutterSpeed;
                this.a.b("ActualShutterSpeed");
            }
        }
        if ((focalvalue = (h)extensions.get("focalvalue")) != null) {
            String actualApertureValue;
            double currentFNumber;
            double maximumFNumber;
            boolean updateList = false;
            double minimumFNumber = focalvalue.e() ? Double.NaN : (double)focalvalue.b();
            if (!(this.o == minimumFNumber || Double.isNaN(this.o) && Double.isNaN(minimumFNumber))) {
                this.o = minimumFNumber;
                updateList = true;
            }
            if (!(this.p == (maximumFNumber = focalvalue.e() ? Double.NaN : (double)focalvalue.a()) || Double.isNaN(this.p) && Double.isNaN(maximumFNumber))) {
                this.p = maximumFNumber;
                updateList = true;
            }
            if (updateList) {
                this.a.a("APERTURE");
            }
            if (focalvalue.e()) {
                currentFNumber = Double.NaN;
                actualApertureValue = null;
            } else {
                currentFNumber = focalvalue.c();
                actualApertureValue = focalvalue.c() < 10.0f ? String.format(Locale.getDefault(), "%1.1f", currentFNumber) : String.format(Locale.getDefault(), "%1.0f", currentFNumber);
                actualApertureValue = String.format("<%s/%s>", "APERTURE", actualApertureValue);
            }
            if (!(this.n == currentFNumber || Double.isNaN(this.n) && Double.isNaN(currentFNumber))) {
                this.n = currentFNumber;
                this.m = actualApertureValue;
                this.a.b("ActualApertureValue");
            }
        }
        if ((expcomp = (d)extensions.get("expcomp")) != null) {
            String actualExposureCompensation;
            double currentExposureCompensation;
            double maximunExposureCompensation;
            boolean updateList = false;
            double minimumExposureCompensation = expcomp.e() ? Double.NaN : (double)expcomp.b();
            if (!(this.w == minimumExposureCompensation || Double.isNaN(this.w) && Double.isNaN(minimumExposureCompensation))) {
                this.w = minimumExposureCompensation;
                updateList = true;
            }
            if (!(this.x == (maximunExposureCompensation = expcomp.e() ? Double.NaN : (double)expcomp.a()) || Double.isNaN(this.x) && Double.isNaN(maximunExposureCompensation))) {
                this.x = maximunExposureCompensation;
                updateList = true;
            }
            if (updateList) {
                this.a.a("EXPREV");
            }
            if (expcomp.e()) {
                currentExposureCompensation = Double.NaN;
                actualExposureCompensation = null;
            } else {
                currentExposureCompensation = expcomp.c();
                actualExposureCompensation = currentExposureCompensation != 0.0 ? String.format(Locale.getDefault(), "%+1.1f", currentExposureCompensation) : "0.0";
                actualExposureCompensation = String.format("<%s/%s>", "EXPREV", actualExposureCompensation);
            }
            if (!(this.v == currentExposureCompensation || Double.isNaN(this.v) && Double.isNaN(currentExposureCompensation))) {
                this.v = currentExposureCompensation;
                this.u = actualExposureCompensation;
                this.a.b("ActualExposureCompensation");
            }
        }
        if ((isospeedvalue = (k)extensions.get("isospeedvalue")) != null) {
            String actualIsoSpeed;
            double currentIsoSpeed;
            boolean autoIsoSpeedWarning;
            if (isospeedvalue.e() && this.A != (autoIsoSpeedWarning = isospeedvalue.f())) {
                this.A = autoIsoSpeedWarning;
                this.a.b("ActualIsoSensitivityWarning");
            }
            if (isospeedvalue.c()) {
                currentIsoSpeed = Double.NaN;
                actualIsoSpeed = null;
            } else {
                currentIsoSpeed = isospeedvalue.b();
                actualIsoSpeed = isospeedvalue.a() ? "Low" : String.format(Locale.getDefault(), "%1.0f", currentIsoSpeed);
                actualIsoSpeed = String.format("<%s/%s>", "ISO", actualIsoSpeed);
            }
            if (!(this.z == currentIsoSpeed || Double.isNaN(this.z) && Double.isNaN(currentIsoSpeed))) {
                this.z = currentIsoSpeed;
                this.y = actualIsoSpeed;
                this.a.b("ActualIsoSensitivity");
            }
        }
        if ((expphotowarning = (e)extensions.get("expphotowarning")) != null) {
            if (this.B != expphotowarning.a()) {
                this.B = expphotowarning.a();
                this.a.b("ExposureWarning");
            }
            if (this.C != expphotowarning.b()) {
                this.C = expphotowarning.b();
                this.a.b("ExposureMeteringWarning");
            }
        }
        if (this.a.a() && this.a.b() && (zoominfo = (r)extensions.get("zoominfo")) != null && this.e != zoominfo.c()) {
            this.e = zoominfo.c();
            this.a.b("ActualFocalLength");
        }
        if ((maxmovietime2 = (l)extensions.get("maxmovietime2")) != null && this.l != (double)maxmovietime2.a()) {
            this.l = maxmovietime2.a();
            this.a.b("RemainingVideoCapacity");
        }
        if ((spiritLevel = (q)extensions.get("levelvial")) != null) {
            String orientation;
            HashMap<String, Object> digitalSpiritLevel = new HashMap<String, Object>();
            switch (spiritLevel.c()) {
                case 0: {
                    orientation = "landscape";
                    break;
                }
                case 1: {
                    orientation = "portrait_left";
                    break;
                }
                case 2: {
                    orientation = "landscape_upside_down";
                    break;
                }
                case 3: {
                    orientation = "portrait_right";
                    break;
                }
                case 4: {
                    orientation = "facedown";
                    break;
                }
                case 5: {
                    orientation = "faceup";
                    break;
                }
                default: {
                    orientation = "?";
                }
            }
            digitalSpiritLevel.put("orientation", orientation);
            if (spiritLevel.b()) {
                digitalSpiritLevel.put("pitch", Float.valueOf(spiritLevel.f()));
            } else {
                digitalSpiritLevel.put("pitch", Float.valueOf(Float.NaN));
            }
            if (spiritLevel.a()) {
                digitalSpiritLevel.put("roll", Float.valueOf(spiritLevel.e()));
            } else {
                digitalSpiritLevel.put("roll", Float.valueOf(Float.NaN));
            }
            boolean updateLevelGauge = false;
            if (this.D != null) {
                String oldOrientation;
                String newOrientation = (String)digitalSpiritLevel.get("orientation");
                if (!newOrientation.equals(oldOrientation = (String)this.D.get("orientation"))) {
                    updateLevelGauge = true;
                }
                if (!updateLevelGauge) {
                    float newRolling = ((Float)digitalSpiritLevel.get("roll")).floatValue();
                    float oldRolling = ((Float)this.D.get("roll")).floatValue();
                    if (Float.isNaN(newRolling) && !Float.isNaN(oldRolling) || !Float.isNaN(newRolling) && Float.isNaN(oldRolling)) {
                        updateLevelGauge = true;
                    } else if (!Float.isNaN(newRolling) && !Float.isNaN(oldRolling) && newRolling != oldRolling) {
                        updateLevelGauge = true;
                    }
                }
                if (!updateLevelGauge) {
                    float newPitching = ((Float)digitalSpiritLevel.get("pitch")).floatValue();
                    float oldPitching = ((Float)this.D.get("pitch")).floatValue();
                    if (Float.isNaN(newPitching) && !Float.isNaN(oldPitching) || !Float.isNaN(newPitching) && Float.isNaN(oldPitching)) {
                        updateLevelGauge = true;
                    } else if (!Float.isNaN(newPitching) && !Float.isNaN(oldPitching) && newPitching != oldPitching) {
                        updateLevelGauge = true;
                    }
                }
            } else {
                updateLevelGauge = true;
            }
            if (updateLevelGauge) {
                this.D = digitalSpiritLevel;
                this.a.b("LevelGauge");
            }
        }
        HashMap<String, RectF> detectedHumanFaces = new HashMap<String, RectF>();
        OLYCamera.LiveViewSize liveViewSize = this.a.c();
        for (String key : new String[]{"facerecognize1", "facerecognize2", "facerecognize3", "facerecognize4", "facerecognize5", "facerecognize6", "facerecognize7", "facerecognize8"}) {
            g facerecognize = (g)extensions.get(key);
            if (facerecognize == null) continue;
            Rect detectedRect = facerecognize.a();
            if (detectedRect.left == 0 && detectedRect.top == 0 && detectedRect.right == 0 && detectedRect.bottom == 0) continue;
            float left = (float)detectedRect.left / (float)liveViewSize.getWidth();
            float top = (float)detectedRect.top / (float)liveViewSize.getHeight();
            float right = (float)detectedRect.right / (float)liveViewSize.getWidth();
            float bottom = (float)detectedRect.bottom / (float)liveViewSize.getHeight();
            RectF normalizedRect = new RectF(left, top, right, bottom);
            detectedHumanFaces.put(key, normalizedRect);
        }
        boolean updateDetectedHumanFaces = false;
        if (this.E != null) {
            if (detectedHumanFaces.size() != this.E.size()) {
                updateDetectedHumanFaces = true;
            } else {
                for (String key : detectedHumanFaces.keySet()) {
                    RectF newRect = (RectF)detectedHumanFaces.get(key);
                    RectF oldRect = this.E.get(key);
                    if (newRect != null && oldRect != null && newRect.equals((Object)oldRect)) continue;
                    updateDetectedHumanFaces = true;
                    break;
                }
            }
        } else {
            updateDetectedHumanFaces = true;
        }
        if (updateDetectedHumanFaces) {
            this.E = detectedHumanFaces;
            this.a.b("DetectedHumanFaces");
        }
    }

    public void updateWithCommandResultOfGetState(Map<String, Object> cameraStatus) {
        String cardState;
        String highTemperatureString = (String)cameraStatus.get("imagingstate");
        boolean hightemperature = false;
        if (highTemperatureString != null) {
            hightemperature = highTemperatureString.equals("hightemp");
        }
        if (this.d != hightemperature) {
            this.d = hightemperature;
            this.a.b("HighTemperatureWarning");
        }
        if ((cardState = (String)cameraStatus.get("cardstatus")) != null || this.b != null) {
            if (cardState != null && this.b != null) {
                if (!cardState.equals(this.b)) {
                    this.b = cardState;
                    this.a.b("MediaMountStatus");
                }
            } else {
                this.b = cardState;
                this.a.b("MediaMountStatus");
            }
        }
        String lensMountState = (String)cameraStatus.get("lensmountstatus");
        String extendedLensMountStatus = null;
        if (lensMountState != null) {
            String electricZoom = (String)cameraStatus.get("electriczoom");
            String macroSetting = (String)cameraStatus.get("macrosetting");
            extendedLensMountStatus = String.format("%s%s%s", lensMountState, "OK".equals(electricZoom) ? "+electriczoom" : "", "OK".equals(macroSetting) ? "+macro" : "");
        } else {
            extendedLensMountStatus = lensMountState;
        }
        if (extendedLensMountStatus != null || this.c != null) {
            if (extendedLensMountStatus != null && this.c != null) {
                if (!extendedLensMountStatus.equals(this.c)) {
                    this.c = extendedLensMountStatus;
                    this.a.b("LensMountStatus");
                }
            } else {
                this.c = extendedLensMountStatus;
                this.a.b("LensMountStatus");
            }
        }
        if (this.c != null && this.c.startsWith("normal")) {
            String teleFocalLengthString;
            String wideFocalLengthString;
            String focalLengthString;
            if (!(this.a.a() && this.a.b() || (focalLengthString = (String)cameraStatus.get("focallength")) == null)) {
                try {
                    int focalLength = Integer.parseInt(focalLengthString);
                    if (this.e != focalLength) {
                        this.e = focalLength;
                        this.a.b("ActualFocalLength");
                    }
                }
                catch (NumberFormatException e2) {
                    // empty catch block
                }
            }
            if ((wideFocalLengthString = (String)cameraStatus.get("widefocallength")) != null) {
                try {
                    int wideFocalLength = Integer.parseInt(wideFocalLengthString);
                    if (this.f != wideFocalLength) {
                        this.f = wideFocalLength;
                        this.a.b("MinimumFocalLength");
                    }
                }
                catch (NumberFormatException e3) {
                    // empty catch block
                }
            }
            if ((teleFocalLengthString = (String)cameraStatus.get("telefocallength")) != null) {
                try {
                    int teleFocalLength = Integer.parseInt(teleFocalLengthString);
                    if (this.g != teleFocalLength) {
                        this.g = teleFocalLength;
                        this.a.b("MaximumFocalLength");
                    }
                }
                catch (NumberFormatException e4) {}
            }
        } else {
            if (this.e != 0) {
                this.e = 0;
                this.a.b("ActualFocalLength");
            }
            if (this.f != 0) {
                this.f = 0;
                this.a.b("ActualFocalLength");
            }
            if (this.g != 0) {
                this.g = 0;
                this.a.b("ActualFocalLength");
            }
        }
        if (this.b != null && this.b.equals("normal")) {
            String cardremainbyteString = (String)cameraStatus.get("cardremainbyte");
            if (cardremainbyteString != null) {
                try {
                    long cardremainbyte = Long.parseLong(cardremainbyteString);
                    if (this.j != cardremainbyte) {
                        this.j = cardremainbyte;
                        this.a.b("RemainingMediaCapacity");
                    }
                }
                catch (NumberFormatException e5) {
                    // empty catch block
                }
            }
            String cardremainnumString = (String)cameraStatus.get("cardremainnum");
            if (cardremainbyteString != null) {
                try {
                    int cardremainnum = Integer.parseInt(cardremainnumString);
                    if (this.k != cardremainnum) {
                        this.k = cardremainnum;
                        this.a.b("RemainingImageCapacity");
                    }
                }
                catch (NumberFormatException e6) {
                    // empty catch block
                }
            }
            String cardremainsecString = (String)cameraStatus.get("cardremainsec");
            if (cardremainbyteString != null) {
                try {
                    int cardremainsec = Integer.parseInt(cardremainsecString);
                    if (this.l != (double)cardremainsec) {
                        this.l = cardremainsec;
                        this.a.b("RemainingVideoCapacity");
                    }
                }
                catch (NumberFormatException e7) {}
            }
        } else {
            if (this.j != 0L) {
                this.j = 0L;
                this.a.b("RemainingMediaCapacity");
            }
            if (this.k != 0) {
                this.k = 0;
                this.a.b("RemainingImageCapacity");
            }
            if (this.l != 0.0) {
                this.l = 0.0;
                this.a.b("RemainingVideoCapacity");
            }
        }
    }
}

