package org.ginkgo.gcov.builder;

import java.util.Map;

import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.ginkgo.gcov.parser.IParser;
import org.ginkgo.gcov.parser.LineCoverageParser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class LineCoverageBuilder extends Builder {
	private IParser gcovParser;
	public static final String BUILDER_ID = "org.ginkgo.gcov.markerBuilder";

	public void checkXML(IResource resource) {
		if (resource instanceof IFile && resource.getName().endsWith(".gcov")) {
			IFile file = (IFile) resource;
			LineCoverageParser.deleteMarkers(file);
//			XMLErrorHandler reporter = new XMLErrorHandler(file);
			try {
				getParser().parse(file);
			} catch (Exception e1) {
			}
		}
	}
	IParser getParser() throws ParserConfigurationException,
	SAXException {
	if (gcovParser == null){
		gcovParser = new LineCoverageParser(); 
	}
	return gcovParser;
	}
}
