package org.ginkgo.gcov.builder;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.ginkgo.gcov.model.CoverageData;

public class CoverageLister implements ICoverageListener {
	/* ( Javadoc)
	 * coverageSummaryListener
	 * @see org.ginkgo.gcov.builder.ICoverageListener#addData(org.eclipse.core.resources.IProject, org.ginkgo.gcov.builder.CoverageData)
	 */
	public void addCoverageData(IProject project, CoverageData cov)
			throws CoreException {
		if(cov.getElementType().equals("File")){
			project.setPersistentProperty(new QualifiedName(cov.getElementName(),"persent"), cov.getPersent());//(elementName + "persent", persent);
			project.setPersistentProperty(new QualifiedName(cov.getElementName(),"totalLine"), cov.getTotalLine());
		}else if(cov.getElementType().equals("Function")){
			project.setPersistentProperty(new QualifiedName(cov.getElementName(),"persent"), cov.getPersent());//(elementName + "persent", persent);
			project.setPersistentProperty(new QualifiedName(cov.getElementName(),"totalLine"), cov.getTotalLine());
		}
	}
}
