unit ReplaceDataModule;

interface

uses
  SysUtils, Classes;

type
  TReplaceDM = class(TDataModule)
    procedure DataModuleCreate(Sender: TObject);
    procedure DataModuleDestroy(Sender: TObject);
  private
    { Private 錾 }
    //! uXg
    FReplaceList: TList;
  public
    { Public 錾 }
    procedure LoadFromFile(const filePath: String);
    function Replace(const source: String): String;
  end;
  TReplace = class(TObject)
  private
    FTarget: String;
    FReplace: String;
  public
    constructor Create(const line: String);
    property Target: String read FTarget write FTarget;
    property Replace: String read FReplace write FReplace;
  end;

var
  ReplaceDM: TReplaceDM;

implementation

uses
    MojuUtils, Dialogs, StrUtils;


{$R *.dfm}

//! GXP[v
function UnEscape(const source: String): String;
begin
    // ݒt@Cɂ̂܂܏Ɛݒt@Ĉ폜̂
    // h߂ɉL̕GXP[vł悤ɂ
    // \. \( \) \{ \} \/ \" \\
    Result := MojuUtils.CustomStringReplace(source, '\.', '.');
    Result := MojuUtils.CustomStringReplace(Result, '\(', '(');
    Result := MojuUtils.CustomStringReplace(Result, '\)', ')');
    Result := MojuUtils.CustomStringReplace(Result, '\{', '{');
    Result := MojuUtils.CustomStringReplace(Result, '\}', '}');
    Result := MojuUtils.CustomStringReplace(Result, '\"', '"');
    Result := MojuUtils.CustomStringReplace(Result, '\/', '/');
    Result := MojuUtils.CustomStringReplace(Result, '\\', '\');
end;

//! RXgN^
procedure TReplaceDM.DataModuleCreate(Sender: TObject);
begin
    // uΏەێXg̐
    FReplaceList := TList.Create;
end;
//! fXgN^
procedure TReplaceDM.DataModuleDestroy(Sender: TObject);
var
    i: Integer;
begin
    if (FReplaceList <> nil) then begin
        // Xg̒gfreeĂяo
        for i := FReplaceList.Count - 1 downto 0 do begin
            TObject(FReplaceList.Items[i]).Free;
        end;
        // Xg폜
        FReplaceList.Clear;
        FReplaceList.Capacity := 0;
        FreeAndNil(FReplaceList);
    end;
end;
//! t@Cǂݍݏ
procedure TReplaceDM.LoadFromFile(const filePath: String);
var
    fileStrings: TStringList;
    i: Integer;
    rep: TReplace;
    ignored: Boolean;
begin
    // t@C̑݃`FbN
    if (FileExists(filePath)) then begin
        ignored := False;
        fileStrings := TStringList.Create;
        fileStrings.LoadFromFile(filePath);
        try
            // ׂĂ̍ŝ܂킷
            for i := 0 to fileStrings.Count - 1 do begin
                rep := TReplace.Create(fileStrings[i]);
                // <> ܂܂Ă邩`FbN
                if (AnsiPos('<>', rep.Target) > 0) or
                    (AnsiPos('<>', rep.Replace) > 0) then begin
                    ignored := True;
                end else begin
                    FReplaceList.Add(rep);
                end;
            end;
        finally
            fileStrings.Free;
        end;
        if (ignored) then begin
            ShowMessage('<>܂ޕ/ɒu邱Ƃ͂ł܂B'#13#10'ݒt@CmFĂB');
        end;
    end;
end;

//! u
function TReplaceDM.Replace(const source: String): String;
var
    i: Integer;
    rep: TReplace;
begin
    Result := source;
    // nilł邱Ƃ͖Ô
    if (FReplaceList <> nil) then begin
        for i := FReplaceList.Count - 1 downto 0 do begin
            rep := TReplace(FReplaceList.Items[i]);
            Result := MojuUtils.CustomStringReplace(Result, rep.Target, rep.Replace);
        end;
    end;
end;
//! RXgN^
constructor TReplace.Create(const line: String);
begin
    Replace := '';
    // 1s^uŋ؂
    if (AnsiPos(#9, line) > 0) then begin
        Target  := Copy(line, 0, AnsiPos(#9, line) - 1);
        Replace := Copy(line, AnsiPos(#9, line) + 1, Length(line));
    end else begin
        Target := line;
    end;
    // Target̃GXP[v̕ɖ߂
    Target := UnEscape(Target);
    // replace''̎́ÃXy[Xɐݒ
    if (Replace = '') then begin
        Replace := StrUtils.DupeString(' ', Length(Target));
    end;
end;

end.
