###############################################################################
#
# ɥѡ
#
###############################################################################
package Wiki::Keyword;
use strict;

# 1 ʸ˥ޥåɽ
my $ascii	  = '[\x00-\x7F]';				  # ASCII	   1 ʸ
my $twoBytes   = '[\x8E\xA1-\xFE][\xA1-\xFE]';   # EUC 2 Byte  1 ʸ
my $threeBytes = '\x8F[\xA1-\xFE][\xA1-\xFE]';   # EUC 3 Byte  1 ʸ
my $AsciiOrEUC = "$ascii|$twoBytes|$threeBytes"; # ASCII/EUC   1 ʸ

my $keyword_cache  = 'keywords.cache';  # Ťɥåե
my $keyword_cache2 = 'keywords2.cache'; # ɥåե

#==============================================================================
# 󥹥ȥ饯
#==============================================================================
sub new {
	my $class     = shift;
	my $wiki      = shift;
	my $interwiki = shift;
	my $self      = {};
	
	$self->{wiki}      = $wiki;
	$self->{keywords}  = [];
	$self->{interwiki} = $interwiki;
	
	$self = bless($self,$class);
	$self->load_keywords();
	
	return $self;
}

#==============================================================================
# ɤޤޤ뤫ɤå
#==============================================================================
sub exists_keyword {
	my ($self, $str) = @_;

	my $regexp = $self->{'regexp'};
	return 0 if ($regexp eq q{});

	my $wiki   = $self->{wiki};
	$self->{g_pre} = q{};

	# $regexp  qr/^((?:$AsciiOrEUC)*?)($keywords_regexp)/ 
	# $str ɽ˥ޥå顢
	while ($str =~ /$regexp/) {
		$self->{g_pre} .= $1;
		$self->{g_post} = $';
		my $label = $self->{g_label} = $2;

		# ޥåɤб url ڡ̵̾С
		if (not exists $self->{'keyword'}->{$label}) {

			# ɤڡ̾Ǳǽʤ顢
			if ($wiki->page_exists($label) and $wiki->can_show($label)) {

				# ڡ̾ȥ
				$self->{g_url}  = undef;
				$self->{g_page} = $label;
				return 1;
			}

			# ɤڡ̾ǤʤԲǽʤ顢
			else {

				# 1 ʸʤƥɤƸ
				$label =~ /^($AsciiOrEUC)(.*)$/;
				$self->{g_pre} .= $1;
				$str = $2 . $self->{g_post};
			}
		}
		else {
			my $word = $self->{'keyword'}->{$label};

			# ޥåɤбΤ url ʤ顢
			if ($word->{'type'} eq 'u') {

				# url 
				$self->{g_url}  = $word->{'value'};
				$self->{g_page} = undef;
			}
			else {

				# wiki ڡ
				$self->{g_url}  = undef;
				$self->{g_page} = $word->{'value'};
			}
			return 1;
		}
	}
	return 0;
}

#==============================================================================
# ɤ򥭥åե뤫ɤ߹
#==============================================================================
sub load_keywords {
	my $self = shift;
	my $wiki = $self->{wiki};

	# ڡԲĤʤ顢⤻˽λ
	my $can_show_max = $wiki->_get_can_show_max();
	return if ($can_show_max < 0);

	my $keyword = $self->{'keyword'} = {};
	my $log_dir = $wiki->config('log_dir');
	my $cachefile = $log_dir . '/' . $keyword_cache2;
	$self->{'regexp_list'} = [];

	READ_CACHE: # åͭȽꡢڤɹ
	while (1) {

		# å夬̵ɹ߽ȴ롣
		last READ_CACHE if (not -e $cachefile);

		my $cache_time = (stat $cachefile)[9];
		my $pagelistfile = $log_dir . '/' . $Wiki::DefaultStorage::PAGE_LIST_FILE;

		# DefaultStorage Υڡ̾ŤХåѤʤ
		last READ_CACHE if ($cache_time < (stat $pagelistfile)[9]);

		my $showlevel_file = $wiki->config('config_dir') . '/showlevel.log';

		# ¥ǡŤХåѤʤ
		last READ_CACHE if ($cache_time < (stat $showlevel_file)[9]);

		my $keyword_file = $wiki->config('data_dir') . '/Keyword.wiki';

		# ڡŤХåѤʤ
		last READ_CACHE if ($cache_time < (stat $keyword_file)[9]);

		# ɥåե뤫ɹߡ
		my $buf = Util::load_config_text(undef, $cachefile);
		my @list = split /\n/, $buf;
		my ($type, $label, $value);

		# ǽ 3 ԡƥ桼Υɽ
		foreach my $level (0 .. 2) {
			my $line = shift @list;
			($type, $label, $value) = split /\t/, $line;

			# ե۾ʤ顢ɹߤλ
			if ($type ne 'r' or $label + 0 != $level) {
				$self->{'regexp_list'} = [];
				last READ_CACHE;
			}
			push @{ $self->{'regexp_list'} }, $value;
		}

		# 4 ܰʹߡɤ url ޤ ڡ̾бطɤ߹ࡣ
		foreach my $line (@list) {
			($type, $label, $value) = split /\t/, $line;
			$keyword->{$label} = { 'type'  => $type, 'value' => $value, };
		}
		last READ_CACHE;
	}

	# λǡɽƤʤС
	if (not @{ $self->{'regexp_list'} }) {

		# ɥǡɥåե¸
		$self->parse();
		$self->save_keywords();
	}

	# ߤΥ桼θ¤б륭ɽ򥳥ѥ롣
	my $regexp = $self->{'regexp_list'}->[$can_show_max];
	$self->{'regexp'} = qr/^((?:$AsciiOrEUC)*?)($regexp)/;
}

#==============================================================================
# ɤΥåե򹹿
#==============================================================================
sub save_keywords {
	my $self = shift;

	# FSWiki ɸΥɥå⤳Υߥ󥰤Ǻ
	my $log_dir = $self->{wiki}->config('log_dir');
	my $cache   = "$log_dir/$keyword_cache";
	unlink $cache if (-e $cache);

	# ƥ桼ΥɽХåեɲá
	my $buf = q{};
	foreach my $level (0 .. 2) {
		$buf .= "r\t$level\t" . $self->{'regexp_list'}->[$level] . "\n";
	}

	# ɤ url ޤϥڡ̾бطХåեɲá
	my $keyword = $self->{'keyword'};
	my $word;
	foreach my $label (keys %$keyword){
		$word = $keyword->{$label};
		$buf .= $word->{'type'} . "\t$label\t" . $word->{'value'} . "\n";
	}

	# ХåեƤ򥭥åե¸
	Util::save_config_text(undef, "$log_dir/$keyword_cache2", $buf);
}

#==============================================================================
# ѡʥ󥹥ȥ饯ƤФޤ
#==============================================================================
sub parse {
	my $self = shift;
	my $wiki = $self->{wiki};
	$self->{'keyword'} = {};
	my @keywordlist = ([], [], []);

	require Regexp::Assemble;

	my $ra = Regexp::Assemble->new;

	# ڡΥȥ󥯤ͭʾ硢ڡ̾⥭ɤ˴ޤࡣ
	if ($wiki->config('auto_keyword_page') == 1) {
		my $no_slash_page = $wiki->config('keyword_slash_page') ne '1';
		my %hash = ();
		my ($page, $pat, $level, $label);

		# ڡ̾ο \d\d* ˤѥ̲γǧ
		foreach $page ($wiki->get_page_list()){
			next if ($no_slash_page and index($page, '/') != -1);
			$pat = quotemeta $page;
			$pat =~ s{\d+}{\\d\\d\*}g;	 # ڡ̾ο \d\d* ִ
			$hash{$pat}->{'count'}++;	  # $pat ˶̲Ǥڡο
			$hash{$pat}->{'page'} = $page; # ڡ̾(count = 1 ΤȤ)
		}

		# ̲ǤƤΥѥˤĤơ
		foreach $pat (sort keys %hash) {

			# Υѥ˶̲Ǥڡ 1 ڡΤߤΤȤ
			if ($hash{$pat}->{'count'} == 1) {
				$page = $hash{$pat}->{'page'}; # Υڡ̾
				$level = $wiki->get_page_level($page);

				# ڡ٥ΥɥꥹȤ˥ڡ̾ɲá
				push @{ $keywordlist[$level] }, $page;
				next;
			}

			# Υѥ˶̲ǤڡʣڡΤȤ
			# ̲ѥɽɲá
			# (ƬȾѱѿʤ顢ñ춭 \b ɲ)
			$pat  = "\\b$pat" if ($pat =~ /^(?:\w|\\d)/);
			$pat .= "\\b"	 if ($pat =~ /(?:\w|\\d\*)$/);
			$ra->add($pat);
		}
	}

	# ڡKeywordפ¸ߤСƤɤࡣ
	if ($wiki->page_exists('Keyword')) {

		# ڡKeywordפƤ饭ɥǡ
		my $source = $wiki->get_page('Keyword');
		$source =~ s/\r//g;
		my @lines = split /\n/, $source;
		foreach my $line (@lines) {
			if (index($line, '*') == 0) {
				$self->parse_line($line);
			}
		}

		# ɥǡ顢ɽ
		my $keyword = $self->{'keyword'};
		my ($level, $page, $word);
		foreach my $label (keys %$keyword) {
			$word = $keyword->{$label};

			# ɤбΤ url ʤ顢
			if ($word->{'type'} eq 'u') {

				#  $label 򥭡ɽɲ
				# (ƬȾѱѿʤ顢ñ춭 \b ɲ)
				$label  = quotemeta $label;
				$label  = "\\b$label" if ($label =~ /^\w/);
				$label .= "\\b"	   if ($label =~ /\w$/);
				$ra->add($label);
			}

			# ɤбΤڡ̾ʤ顢
			else {
				$page = $word->{'value'};
				$level = $wiki->get_page_level($page);

				# ڡ٥ΥꥹȤ˥ɤɲá
				push @{ $keywordlist[$level] }, $label;
			}
		}
	}

	$self->{'regexp_list'} = [];
	my $label;

	# ڡ٥ΥꥹΥɤɽɲá
	foreach my $level (0 .. 2) {
		foreach my $page (@{ $keywordlist[$level] }) {

			# ڡ̾ $page 򥭡ɽɲ
			# (ƬȾѱѿʤ顢ñ춭 \b ɲ)
			$page  = quotemeta $page;
			$page  = "\\b$page" if ($page =~ /^\w/);
			$page .= "\\b"	  if ($page =~ /\w$/);
			$ra->add($page);
		}

		# ɽꥹȤ¸
		push @{ $self->{'regexp_list'} }, $ra->clone()->as_string();
	}
}

sub parse_line {
	my $self   = shift;
	my $source = shift;

	return if (not defined $source);

	# $source ˤʤޤǷ֤
	while ($source ne q{}) {

		# ɤ񼰤ʤнλ
		return if (not $source =~ /^[^\[]*(\[.+)$/);

		$source = $1;

		# ̾
		if ($source =~ /^\[([^\[]+?)\|((?:https?|ftp|mailto):[a-zA-Z0-9\.,%~^_+\-%\/\?\(\)!&=:;\*#\@'\$]*)\]/
		 || $source =~ /^\[([^\[]+?)\|(file:[^\[\]]*)\]/
		 || $source =~ /^\[([^\[]+?)\|((?:\/|\.\/|\.\.\/)+[a-zA-Z0-9\.,%~^_+\-%\/\?\(\)!&=:;\*#\@'\$]*)\]/ ) {
			my $label = $1;
			my $url   = $2;
			$source = $';
			$self->url_anchor($url, $label);
		}

		# InterWiki
		elsif ($self->{interwiki}->exists_interwiki($source)) {
			my $label = $self->{interwiki}->{g_label};
			my $url   = $self->{interwiki}->{g_url};
			$source = $self->{interwiki}->{g_post};
			$self->url_anchor($url, $label);
		}

		# ڡ̾
		elsif ($source =~ /^\[\[([^\[]+?)\|(.+?)\]\]/) {
			my $label = $1;
			my $page  = $2;
			$source = $';
			$self->wiki_anchor($page, $label);
		}

		# ǤդURL
		elsif ($source =~ /^\[([^\[]+?)\|(.+?)\]/) {
			my $label = $1;
			my $url   = $2;
			$source = $';
			$self->url_anchor($url, $label);
		}

		# ʾ macth ʤäʤ顢1 ʸʤ롣
		else {
			$source =~ s/^.//;
		}
	}
}

#==============================================================================
# URL
#==============================================================================
sub url_anchor {
	my ($self, $url, $name) = @_;

	$self->{'keyword'}->{$name} = { 'type' => 'u', 'value' => $url };
}

#==============================================================================
# Wiki
#==============================================================================
sub wiki_anchor {
	my $self = shift;
	my $page = shift;
	my $name = shift;
	
	if($name eq ""){
		$name = $page;
	}
	my $keyword = {};
	$keyword->{word} = $name;
	$keyword->{page} = $page;
	push(@{$self->{keywords}},$keyword);
}

1;
