/**
 *  XML Config
 *
 *  Copyright (C) 2006-2017 Teru Kamogashira
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef _XMLCONFIG_HPP
#define _XMLCONFIG_HPP

#include <cstdio>
#include <cstdlib>
#include <cstring>
#include <vector>
#include <string>
#include <map>
#include <new>

#include <expat.h>

#define FV3_XML_BUFSIZE 1024
#define FV3_XML_SECTION "/fv3:config/fv3:section"
#define FV3_XML_KEY     "/fv3:config/fv3:section/fv3:key"
#define FV3_XML_NAME    "fv3:name"
#define FV3_XML_VALUE   "fv3:value"

typedef struct {
  std::map<std::string,std::string> * KeyPairs;
  std::string * tree;
  std::string CurrentSectionName;
} XMLConfigParserData;

class XMLConfig
{
public:
  XMLConfig(){ pData.KeyPairs = &KeyPairs; pData.tree = &tree; }
  virtual ~XMLConfig(){;}
  int registerXML(const char * xmlfile);
  void unregister();
  int getKeyAsInt(const char * key);
  float getKeyAsFloat(const char * key);
  const char * getKeyAsString(const char * key);
private:
  std::map<std::string,std::string> KeyPairs;
  std::string tree; XMLConfigParserData pData;
};

#endif
