/**
 *  XML Config
 *
 *  Copyright (C) 2006-2017 Teru Kamogashira
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "XMLConfig.hpp"

static void ElementStart(void *data, const XML_Char *name, const XML_Char *atts[])
{
  XMLConfigParserData * pData = (XMLConfigParserData*)data;
  pData->tree->append("/");
  pData->tree->append(name);
  int i = 0;
  if(std::string(pData->tree->c_str()) == FV3_XML_SECTION)
    {
      while(1)
	{
	  if(atts[i] == NULL) break;
	  if(std::string(atts[i]) == FV3_XML_NAME)
	    pData->CurrentSectionName = atts[i+1];
	  i += 2;
	}

    }
  if(std::string(pData->tree->c_str()) == FV3_XML_KEY)
    {
      std::string key, value;
      while(1)
	{
	  if(atts[i] == NULL) break;
	  if(std::string(atts[i]) == FV3_XML_NAME)
	    key = atts[i+1];
	  if(std::string(atts[i]) == FV3_XML_VALUE)
	    value = atts[i+1];
	  i += 2;
	}
      std::pair<std::map<std::string,std::string>::iterator,bool> result;
      std::string KeyName = "/" + pData->CurrentSectionName + "/" + key;
      result = pData->KeyPairs->insert(std::pair<std::string,std::string>(KeyName,value));
      if(!result.second) (*pData->KeyPairs)[KeyName] = value;
    }
}

static void ElementEnd(void *data, const XML_Char *name)
{
  XMLConfigParserData * pData = (XMLConfigParserData*)data;
  long strn = strlen(name);
  pData->tree->erase(pData->tree->length()-(strn+1), strn+1);
}

int XMLConfig::registerXML(const char * xmlfile)
{
  int ret = 0;
  char * buf = NULL;
  int eofflag;
  size_t len;
  XML_Parser parser;
  if ((parser = XML_ParserCreate(NULL)) == NULL) return -1;
  XML_SetUserData(parser, (void*)&pData);
  XML_SetElementHandler(parser, ElementStart, ElementEnd);
  FILE * xmlfp = fopen(xmlfile, "rb");
  if(xmlfp == NULL) return -1;
  try{ buf = new char[FV3_XML_BUFSIZE]; }
  catch(std::bad_alloc){ delete[] buf; throw std::bad_alloc(); }
  do
    {
      len = std::fread(buf, sizeof(char), FV3_XML_BUFSIZE, xmlfp);
      if (std::ferror(xmlfp))
	{ std::fclose(xmlfp); ret = -1; break; }
      eofflag = std::feof(xmlfp);
      if ((XML_Parse(parser, buf, (int)len, eofflag)) == 0)
	{ std::fclose(xmlfp); ret = -1; break; }
    } while(!eofflag);
  std::fclose(xmlfp);
  delete[] buf;
  return ret;
}

void XMLConfig::unregister()
{
  KeyPairs.clear();
}

int XMLConfig::getKeyAsInt(const char * key)
{
  return atoi(getKeyAsString(key));
}

float XMLConfig::getKeyAsFloat(const char * key)
{
  return atof(getKeyAsString(key));
}

const char * XMLConfig::getKeyAsString(const char * key)
{
  std::map<std::string,std::string>::iterator result;
  result = KeyPairs.find(std::string(key));
  if(result != KeyPairs.end()) return result->second.c_str();
  return "";
}
