/**
 *  NRev
 *
 *  Copyright (C) 2006-2017 Teru Kamogashira
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __NRev_H
#define __NRev_H

#define EFFECT_NAME "Freeverb3_NReverb"

#include <cstdlib>

#include <new>
#include <vector>
#include <string>
#include <cstdio>

#include <typeinfo>

#include <audioeffectx.h>

#include <freeverb/nrev.hpp>
#include <freeverb/nrevb.hpp>

#include "ProcessBlock.hpp"
#include "Locker.hpp"

#ifdef PLUGDOUBLE
typedef fv3::nrev_ NREV;
typedef fv3::nrevb_ NREVB;
typedef double pfloat_t;
#else
typedef fv3::nrev_f NREV;
typedef fv3::nrevb_f NREVB;
typedef float pfloat_t;
#endif

enum {
  KOFactor, KWet, KDry, KFeedback, KDamp1,
  KDamp2, KDamp3, KReverbTime, KWidth, KDelay,
  KNumParams,
};

class NRevProgram
{
public:
  NRevProgram()
  {
    fOFactor = 3.6, fWet = -15, fDry = -2, fFeedback = .6, fDamp1 = .85, fDamp2 = .85, fDamp3 = .1, fReverbTime = 3, fWidth = 1, fDelay = 0;
    strcpy(name, "(Default Preset)");
  }
  ~NRevProgram(){}
  void setProgram(char * n, float v[KNumParams])
  {
    fOFactor = v[0], fWet = v[1], fDry = v[2], fFeedback = v[3], fDamp1 = v[4], fDamp2 = v[5], fDamp3 = v[6], fReverbTime = v[7], fWidth = v[8], fDelay = v[9];
    strcpy(name, n);
  }
private:
  friend class NRev;
  pfloat_t fOFactor, fWet, fDry, fFeedback, fDamp1, fDamp2, fDamp3, fReverbTime, fWidth, fDelay;
  char name[kVstMaxProgNameLen];
};

class NRev :
  public AudioEffectX, ProcessBlock, Locker
{
public:
  NRev(audioMasterCallback audioMaster) ALIGN_ARG_POINTER;
  virtual ~NRev();
  virtual VstPlugCategory getPlugCategory();
  virtual VstInt32 getProgram();
  virtual void     setProgram(VstInt32 program);
  virtual void setProgramName(char *name);
  virtual void getProgramName(char *name);
  virtual bool getProgramNameIndexed(VstInt32 category, VstInt32 index, char* text);
  virtual void getParameterLabel(VstInt32 index, char *label);
  virtual void getParameterDisplay(VstInt32 index, char *text);
  virtual void getParameterName(VstInt32 index, char *text);
  virtual bool getEffectName (char* name);
  virtual bool getVendorString (char* text);
  virtual bool getProductString (char* text);
  virtual VstInt32 canDo(char* text);
  virtual bool setBypass(bool onOff);
  virtual bool getInputProperties(VstInt32 index, VstPinProperties* properties);
  virtual bool getOutputProperties(VstInt32 index, VstPinProperties* properties);

  virtual void  suspend() ALIGN_ARG_POINTER;
  virtual void  resume() ALIGN_ARG_POINTER;
  virtual void  setSampleRate (float sampleRate) ALIGN_ARG_POINTER;
  virtual float getSampleRate() ALIGN_ARG_POINTER;
  virtual void  setParameter(VstInt32 index, float value) ALIGN_ARG_POINTER;
  virtual float getParameter(VstInt32 index) ALIGN_ARG_POINTER;
  virtual void process               (float **inputs, float **outputs, VstInt32 sampleFrames) ALIGN_ARG_POINTER;
  virtual void processReplacing      (float **inputs, float **outputs, VstInt32 sampleFrames) ALIGN_ARG_POINTER;
#ifdef PLUGDOUBLE
  virtual void processDoubleReplacing(double **inputs, double **outputs, VstInt32 sampleFrames) ALIGN_ARG_POINTER;
#endif
  virtual void processLRModel(pfloat_t *inL, pfloat_t *inR, pfloat_t *outL, pfloat_t *outR, VstInt32 sampleFrames) ALIGN_ARG_POINTER;

  void setConverterType(int type);
  void setLatency(int size);

  static pfloat_t param2model(int index, float value);
  static float model2param(int index, pfloat_t value);
  static pfloat_t pconv(int index, pfloat_t value, bool p2m);
  
private:
  void setParameterM(VstInt32 index, float value);
  void setParameter(VstInt32 index, float value, bool vstp);

  NRevProgram * programs;
  NREV *model, *nrev_, *nrevb_;
  double currentFs;
  int converter_type;
  bool byPass;
};

#endif
