/**
 *  Freeverb3 CPU Checker
 *
 *  Copyright (C) 2007-2014 Teru Kamogashira
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <stdio.h>
#include <stdint.h>
#include <string>
#include <windows.h>
#include <freeverb/utils.hpp>

#ifdef PLUGDOUBLE
typedef fv3::utils_ UTILS;
typedef double pfloat_t;
#else
typedef fv3::utils_f UTILS;
typedef float pfloat_t;
#endif

int main()
{
  uint32_t simdFlag = UTILS::getSIMDFlag();

  MessageBoxW(NULL,
	      L"CPU Instruction Detector for Windows",
	      L"Freeverb3VST",MB_OK);
  MessageBoxW(NULL,
	      L"There are two types of binary distribution.\n"
	      L"\"fast\" is a single precision version, \n"
	      L"which is suitable for realtime effect.\n"
	      L"\"slow\" is a double precision version, \n"
	      L"which may be slower than the fast version.\n"
	      L"\"fast\" version should be used for realtime operation.",
	      L"Freeverb3VST",MB_OK);
  
  std::string fl = "", db = "";
  if((simdFlag&FV3_FLAG_3DNOW))
    { fl = "3DNOW"; }
  if((simdFlag&FV3_FLAG_SSE))
    { fl = "SSE"; }
  if((simdFlag&FV3_FLAG_SSE2))
    { db = "SSE2"; }
  if((simdFlag&FV3_FLAG_SSE3))
    { fl = "SSE3"; }
  if((simdFlag&FV3_FLAG_SSE4_1))
    { fl = "SSE4"; }
  if((simdFlag&FV3_FLAG_AVX))
    { fl = "AVX"; db = "AVX"; }
  
  std::string out = "";
  if(fl != "")
    out =
      "You should use\n"
      "\"fast-" + fl + "-singleprecision\"\n"
      "version for realtime operation.\n";
  else
    out =
      "There are no supported version of single precision plugins.\n";

  if(db != "")
    out += "You can use\n"
      "\"slow-" + db + "-doubleprecision\"\n"
      "version for precise processing.\n";
  else
    out +=
      "There are no supported version of double precision plugins.\n";
  
  MessageBoxA(NULL, out.c_str(), "Freeverb3VST", MB_OK);
}
