/**
 *  IR Programs Library
 *
 *  Copyright (C) 2006-2014 Teru Kamogashira
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "IRPrograms.hpp"

IRPrograms::IRPrograms()
{
  blank[0] = '\0';
  pData.IRPMap = &IRPMap;
  pData.tree = &tree;
}

IRPrograms::~IRPrograms()
{
}

static void ElementStart(void *data, const XML_Char *name, const XML_Char *atts[])
{
  ParserData * pData = (ParserData*)data;
  pData->tree->append("/");
  pData->tree->append(name);
  int i = 0;
  if(std::strcmp(pData->tree->c_str(), FV3_XML_IR_ELEMENT) == 0)
    {
      VstInt32 irp = 0;
      std::string filename;
      while(1)
	{
	  if(atts[i] == NULL) break;
	  if(strcmp(atts[i], FV3_XML_IR_MSB) == 0)
	    irp = (irp&0x00ffff) | (atoi(atts[i+1])*0x10000);
	  if(strcmp(atts[i], FV3_XML_IR_LSB) == 0)
	    irp = (irp&0xff00ff) | (atoi(atts[i+1])*0x100);
	  if(strcmp(atts[i], FV3_XML_IR_PRG) == 0)
	    irp = (irp&0xffff00) | atoi(atts[i+1]);
	  if(std::string(atts[i]) == FV3_XML_IR_FILE)
	    filename = atts[i+1];	  
	  i += 2;
	}
      std::pair<std::map<VstInt32,std::string>::iterator,bool> result;
      result =
	pData->IRPMap->insert(std::pair<VstInt32,std::string>(irp,filename));
      if(!result.second) (*pData->IRPMap)[irp] = filename;
    }
}

static void ElementEnd(void *data, const XML_Char *name)
{
  ParserData * pData = (ParserData*)data;
  long strn = strlen(name);
  pData->tree->erase(pData->tree->length()-(strn+1), strn+1);
}

#define XML_BUFSIZE 1024
int IRPrograms::registerFromXML(const char * xmlfile)
{
  int ret = 0;
  char * buf = NULL;
  int eofflag;
  size_t len;
  XML_Parser parser;
  if ((parser = XML_ParserCreate(NULL)) == NULL) return -1;
  XML_SetUserData(parser, (void*)&pData);
  XML_SetElementHandler(parser, ElementStart, ElementEnd);
  FILE * xmlfp = fopen(xmlfile, "rb");
  if(xmlfp == NULL) return -1;

  try
    {
      buf = new char[XML_BUFSIZE];
    }
  catch(std::bad_alloc)
    {
      delete[] buf;
      throw std::bad_alloc();
    }

  do
    {
      len = std::fread(buf, sizeof(char), BUFSIZE, xmlfp);
      if (std::ferror(xmlfp))
	{
	  std::fclose(xmlfp);
	  ret = -1;
	  break;
	};
      eofflag = std::feof(xmlfp);
      if ((XML_Parse(parser, buf, (int)len, eofflag)) == 0)
	{
	  std::fclose(xmlfp);
	  ret = -1;
	  break;
	}
    } while(!eofflag);
  std::fclose(xmlfp);
  delete[] buf;
  return ret;
}

void IRPrograms::unregister()
{
  IRPMap.clear();
}

const char * IRPrograms::getFilenameA(VstInt32 msb, VstInt32 lsb, VstInt32 prg)
{
  VstInt32 key = msb*0x10000 + lsb*0x100 + prg;
  std::map<VstInt32,std::string>::iterator result;
  result = IRPMap.find(key);
  if(result != IRPMap.end()) return result->second.c_str();
  return blank;
}
