/* 
 * FreeModbus Libary: uOS-elvees Port
 * ru UTF8
    Copyright (C) 2015  Alexandr Litjagin (aka AlexRayne) AlexRaynePE196@gmail.com
                                                          AlexRaynePE196@hotbox.ru
   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
 */


#include "runtime/lib.h"
#include "kernel/uos.h"
#include <kernel/internal.h>
#include <stddef.h>

#include <hwconfig.h>
#include <port.h>
#include <mbport.h>

#include <mb.h>
#include <../mbmulty_wrap.h>
#include <portevent.h>
#include <mblocal.h>

#include "mbtask.h"
#include <trace.h>

const UCHAR     ucSlaveID[] = SlaveID;
#define ucSlaveIDsize ucSlaveStrIDsize(ucSlaveID)


void modbus_slave_task (void *data)
{
    eMBErrorCode    eStatus;
    MB_PORT_DECL_FROM(data);

    //trace_debug0();

    /* Enable the Modbus Protocol Stack. */
    eStatus = eMBEnable(  );
    DEBUG_MBprintf(vMB_info, "mbslave[%s]:started to state%d\n"
            , task_current->name, mb_self->State);

    while (eStatus == MB_ENOERR) {

    while(1) {
        do {
            if (eMBPoll(  ) == MB_CLOSED)
                break;
        } while (MBHasEvent()) ;
        if (eMBState == STATE_CLOSED)
            break;
        MBWaitEvent();
    }

    break;
    }
    
    eMBDisable(  );
    eStatus = eMBClose(  );
    DEBUG_MBprintf(vMB_info, "mbslave[%s]:task close\n", task_current->name);
    task_exit(0);
}
