#ifndef _mb_multyport_h_
#define _mb_multyport_h_
/*
 * FreeModbus Libary: uOS-elvees Port
 * ru UTF8
    Copyright (C) 2015  Alexandr Litjagin (aka AlexRayne) AlexRaynePE196@gmail.com
                                                          AlexRaynePE196@hotbox.ru
   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.

   here is CRUTCHES wrappers on ModBus v1.6 definitions, that intends to implement
   new v2 layout, allow multiple ModBus instances co-exists in one system.
*/


/*  Multiple intances mode turn on by mbconfig.h:MB_MULTY_xxx_PORTS definitions
 *  multy-mode defines structures for MB-controllers:
 *      1) mb_instance - basic controller for MB-server(slave), that can use
 *          arbitrary Net-InterFace (nif) and Port-defined Events que
 *      2) mb_server - a child of mb_instance, basic controller for client(master)
 *      3) mb_nif - prototype for Net-Interfaces. mbmulty_wrap_rtu defines interface
 *          for RTU port
 *
 *  - for converts current static-style API definitions to multy just appends aka "this" reference
 *      as 1st parameter - this one aliased as MB_SELF - for basic instance and MBC_SELF - for masters.
 *  - the new-style methods are decorated by MB_METHOD_NAME(name) - under this names you find most routines.
 *  - declarations for them denoted by wraper MB_METHOD_DECL(name, ...) (or MB_METHOD_DECL1(name) - for void functions )
 *  - most original routines are overrided by <original name> macro that just invoke new-style method with
 *      MB_SELF reference. this overrides denoted by MB_METHOD_ACT[1]
 *
 *  - controllers structures are collects old static veriables, and now it wraps by <original name> macros
 *     defined in <mbmulty_wrap.h>, <mbmulty_wrap_rtu.h>
 * */

#include <portgen.h>
#include <mbconfig.h>
#include <mbstruct.h>

#if MB_MULTY_PORTS > 0
//* declares that multy-intances style used
#   define  MB_IS_MULTY
//* denotes
#   define  MB_SELF         mb_self
#   define  MB_WITH_SELF    MB_SELF ,
#   define  MB_PORT         mb_instance* MB_SELF
#   define  MB_WITH_PORT    MB_PORT ,

#   define MB_PORT_DECL_FROM(ptr) MB_PORT = (mb_instance*)(ptr)

//* mb API interface methods
#   define  MB_IF_DECL(name, ...) name(MB_WITH_PORT __VA_ARGS__)
#   define  MB_IF_DECL1(name)     name(MB_PORT)

//* mb internal methods
#   define  MB_METHOD_NAME(name)      mb_##name
#   define  MB_METHOD_DECL(name, ...) MB_METHOD_NAME(name)(MB_WITH_PORT __VA_ARGS__)
#   define  MB_METHOD_DECL1(name)     MB_METHOD_NAME(name)(MB_PORT)
#   define  MB_METHOD_ACT(name, ...)  MB_METHOD_NAME(name)(MB_WITH_SELF __VA_ARGS__)
#   define  MB_METHOD_ACT1(name)      MB_METHOD_NAME(name)(MB_SELF)

#ifndef MB_LOCAL_SPEC
//* if stack variables are more complex vs static ones - better use statics for size&speed optimize
//*  for multiple realisation theres is no effort
#   define  MB_LOCAL_SPEC
#endif




#   define MBC_SELF        mbm_self
#   define MBC_WITH_SELF   MBC_SELF ,
#   define MB_MASTER       mb_master* MBC_SELF
#   define MB_WITH_MASTER   MB_MASTER ,

#   define MB_SERVE_DECL_FROM(ptr) MB_MASTER = (mb_master*)(ptr)
#   define MB_SERVE_PORT_DECL  MB_PORT = &(MBC_SELF->mb)

#   define  MBS_METHOD_DECL(name, ...) MB_METHOD_NAME(name)(MB_WITH_MASTER __VA_ARGS__)
#   define  MBS_METHOD_DECL1(name)     MB_METHOD_NAME(name)(MB_MASTER)
#   define  MBS_METHOD_ACT(name, ...)  MB_METHOD_NAME(name)(MBC_WITH_SELF __VA_ARGS__)
#   define  MBS_METHOD_ACT1(name)      MB_METHOD_NAME(name)(MBC_SELF)

#   define MB_NET            nif
#   define MB_NETIF          mb_nif* MB_NET
#   define MB_PORT_NET_DECL  MB_NETIF = (MB_SELF->MB_NET)
#   define MB_PORT_NET_DECLAS(astype)  astype MB_NET = (astype)(MB_SELF->MB_NET)



struct mb_instance_s;
typedef struct mb_instance_s mb_instance;

struct mb_master_s;
typedef struct mb_master_s mb_master;

struct mb_nif_s;
typedef struct mb_nif_s mb_nif;

#include <mbframe.h>
#include <mbproto.h>
//* import  mb_events_que struct
#include <portevent.h>

#ifdef __cplusplus
PR_BEGIN_EXTERN_C
#endif

struct mb_instance_s {
        UCHAR       Address;
        MBStatus    Status;
        MBState_t   State;
        eMBMode     CurrentMode;
        void*       MB_NET;
        mb_events_que   Events;

#   ifdef MB_USE_FPTRCUR

        peMBFrameSend       FramePostCur;

        peMBFrameSend       FrameSendCur;
        pvMBFrameStart      FrameStartCur;
        pvMBFrameStop       FrameStopCur;
        peMBFrameReceive    FrameReceiveCur;
        pvMBFrameClose      FrameCloseCur;

        /* Callback functions required by the porting layer. They are called when
         * an external event has happend which includes a timeout or the reception
         * or transmission of a character.
         */
        BOOL( *FrameCBByteReceived ) ( MB_PORT );
        BOOL( *FrameCBTransmitterEmpty ) ( MB_PORT );
        BOOL( *PortCBTimerExpired ) ( MB_PORT );

        BOOL( *FrameCBReceiveFSMCur ) ( MB_PORT );
        BOOL( *FrameCBTransmitFSMCur ) ( MB_PORT );
#   endif//MB_USE_FPTRCUR

        xMBFunctionHandler FuncHandlers[MB_FUNC_HANDLERS_MAX];
};

struct mb_master_s{
        mb_instance     mb;

        UCHAR           SentAddress;
        const  UCHAR *  SentBuf;
        UFRAMESIZE      SentLength;

        //ACK frame valid after post completes with ok
        MB_frame_PDU*   ACKFrame;
        UCHAR           ACKAddress;
        UFRAMESIZE      ACKLength;
        USHORT          retry_count;
        eMBErrorCode    PostState;
        MB_protocol_state state;

        USHORT          retry_limit;

        void (*On_SentOk)(MB_WITH_MASTER     eMBErrorCode code);
        void (*On_AckError)(MB_WITH_MASTER   eMBErrorCode code);
        void (*On_Error)(MB_WITH_MASTER      eMBErrorCode code);
};

struct mb_nif_s{
    UFRAMESIZE FrameLimit;
};

#ifdef __cplusplus
PR_END_EXTERN_C
#endif

#else //#if MB_MULTY_PORTS > 0
#   define  MB_SELF
#   define  MB_PORT         void
#   define  MB_WITH_SELF
#   define  MB_WITH_PORT

#   define MBC_SELF
#   define MB_MASTER        void

#ifndef MB_LOCAL_SPEC
//* if stack variables are more complex vs static ones - better use statics for size&speed optimize
#   define  MB_LOCAL_SPEC   static
#endif

#endif//#if MB_MULTY_PORTS > 0



#endif //_mb_multyport_h_

