/*
* FreeModbus Libary: uOS-elvees Port
 * ru UTF8
    Copyright (C) 2015  Alexandr Litjagin (aka AlexRayne) AlexRaynePE196@gmail.com
                                                          AlexRaynePE196@hotbox.ru
   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   
   This file used for declarations for uOS/mbXtask units
 */
#ifndef _portevent_h_
#define _portevent_h_

#include <portgen.h>
#include <mbmulty.h>
#include <mbport.h>

#ifdef __cplusplus
extern "C" {
#endif

/*-----------------------    EventsQue    -----------------------------------*/
/* эта безлоковая очередь расчитана на без-конкурентное считывание (одним приемником)
 *  и без-конкурентную запись (в прерываниях)
 *  МИПС не имеет дешевых интерлоков, поэтому сделать больше не вижу как
 * */

#define eQueueIMASK 3
#define eQueueSize  (eQueueIMASK+1)
struct _EventsQue{
    eMBEventType    events[eQueueSize];
    unsigned        rdi;
    unsigned        wri;
    volatile BOOL   InException;
    //! this handler process events for TCP-netif in poll thread
    eMBEventType    (*OnNoPollEvent)(MB_WITH_PORT eMBEventType event);
    mutex_group_t*  signals_group;
};
typedef struct _EventsQue mb_events_que;

/* ----------------------- Variables ----------------------------------------*/
#ifndef MB_IS_MULTY
extern EventsQue eQueuedEvent;
#else
#   define eQueuedEvent (MB_SELF->Events)
#endif

/* ----------------------- Event Methods for pollers ------------------------*/

#define MBHasEvent()    MB_METHOD_ACT1(MBHasEvent)
#define MBWaitEvent()   MB_METHOD_ACT1(MBWaitEvent)

BOOL MB_METHOD_DECL1(MBHasEvent);
BOOL MB_METHOD_DECL1(MBWaitEvent);



#ifdef __cplusplus
}
#endif

#endif
