/*
 * FreeModbus Libary: uOS-elvees Port
 * ru UTF8
    Copyright (C) 2015  Alexandr Litjagin (aka AlexRayne) AlexRaynePE196@gmail.com
                                                          AlexRaynePE196@hotbox.ru
   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
 */

#ifndef _PORT_H
#define _PORT_H

/* ----------------------- Platform includes --------------------------------*/
#include "runtime/lib.h"
#include "kernel/uos.h"
#include <portgen.h>

#define ENTER_CRITICAL_SECTION( )   MB_PortEnterCritical()
#define EXIT_CRITICAL_SECTION( )    MB_PortExitCritical()

/*! MODBUS RTU use this macro to define an size of internal receive buffer 
 * */
//#define MB_SER_RECV_SIZE 256

/* ----------------------- Prototypes ---------------------------------------*/
void            MB_PortEnterCritical( void );
void            MB_PortExitCritical( void );

/* ----------------------- ELVEES platform specifics ---------------------------*/
#include "hwconfig.h"

#include "multicore/nvcom02t/nvcom02_mem_map.h"
#include "multicore/nvcom02t/nvcom02_uart_regs.h"
#include "multicore/nvcom02t/nvcom02_mfbsp_regs.h"
#include "multicore/nvcom02t/nvcom02_system_regs.h"

/**\~russian
 *  это макро включает использование блочной отсылки буффера вместо посимвольной
 *  через xMBPortSerialPutByte 
 * */
#ifdef MC_UART_FIFO_SIZE
#define MB_USE_TXFIFO
#endif

//* same as xMBPortSerialGetByte, also returns uart error status
//* \param[out] puByte - low byte - received char, 
//*                       high byte - error info, 0 - if no errors
#define MB_HAVE_XGETBYTE

/* this macro declares that transmiter is not responded on output beffer empty,
 * therefore port direction control must check that port is not busy by transmit
 * */
#define MB_CONTROL_BY_LASY_TXBUF

//для более компактного кода
#define MB_OPTMISE_SIZE     0
//для кода более точного к таймаутам
#define MB_OPTMISE_ACCURATE 1

#define MB_OPTMISE      MB_OPTMISE_ACCURATE



#include <protoport.h>
#include <mblocal.h>
//! here is <ip> exported
#include <eth_server.h>

#ifndef DEBUG_MBtx
#define DEBUG_MBtx(x)
#endif
#ifndef DEBUG_MBrx
#define DEBUG_MBrx(x)
#endif

#ifndef MB_TCP_CONN_LIMIT
#define MB_TCP_CONN_LIMIT   1
#endif

#include <trace.h>



/* ----------------------- Event specific ------------------------------------*/

#include <mbmulty.h>
#include <portevent.h>

#define MB_PortSetWithinException(...) MB_METHOD_ACT(MB_PortSetWithinException, __VA_ARGS__)
#define MB_PortIsWithinException()     MB_METHOD_ACT1(MB_PortIsWithinException)

INLINE CODE_ISR 
void MB_METHOD_DECL(MB_PortSetWithinException, BOOL bInException ){
    eQueuedEvent.InException = bInException;
};

INLINE CODE_ISR 
BOOL MB_METHOD_DECL1(MB_PortIsWithinException){return eQueuedEvent.InException;};

#define vMBPortEventClose()



#endif
