#ifndef _trace_h_
#define _trace_h_
/*
    elvees stuff library
    Copyright (C) 2015  Alexandr Litjagin (aka AlexRayne) AlexRaynePE196@gmail.com
                                                          AlexRaynePE196@hotbox.ru

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   
   this is dummy testprobes definitions used for debug
   if you intends to profile isr-level modbus routines timings, you should
   define your own markers that highlight desired event. for example via port pins toggling
   at present uos port can show mb_irx mb_itx mb_to - events
   events are exposes some part of code, and you need declare actions:
       probe_XXX_on()  - for entry
       probe_XXX_off() - for exit

 * */

#ifdef __cplusplus
extern "C" {
#endif



#define trace_probes(id) \
static inline void trace_probe_##id##_on(void) {;} \
static inline void trace_probe_##id##_off(void) {;} 

trace_probes(mb_irx)
trace_probes(mb_itx)
trace_probes(mb_to)
trace_probes(mb_ev)
trace_probes(mb_poll)

#ifdef __cplusplus
}
#endif

#endif //_trace_h_
