/* 
 * FreeModbus Libary: A portable Modbus implementation for Modbus ASCII/RTU.
    general types and language defines for platform scpecifics stuff library
    Copyright (C) 2015  Alexandr Litjagin (aka AlexRayne) AlexRaynePE196@gmail.com
                                                          AlexRaynePE196@hotbox.ru
   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
 *
 *
 * this is a dummy implementation of port.h interface part used for expose 
 *  to mb headers part of porting general definitions - types, macrodefinitins
 *  used by heeaders, and it just provides port header. 
 *  implementation part of mb project uses port.h header, and it can be used
 *  to provide additional platform specific code to mb implementation, still 
 *  using mb headers avoiding circular headers including.
 *  
 */
#ifndef _modbus_protoport_h_
#define _modbus_protoport_h_

/* ----------------------- Protocol TimeOuts --------------------------------*/
#include <uos-conf.h>

/*    -
 * */
#define MB_ACK_TIMEOUTms                1
#define MB_TURNAROUND_TIMEOUTms         1

#define MB_ONEMS                (1000/50)

#ifdef USEC_TIMER
#define MB_ACK_TIMEOUT          (MB_ACK_TIMEOUTms*MB_ONEMS)
#define MB_TURNAROUND_TIMEOUT   (MB_TURNAROUND_TIMEOUTms*MB_ONEMS)
#define MB_TXLOCK_TIMEOUT       (2*MB_ONEMS)
#else
#define MB_ACK_TIMEOUT          (MB_ACK_TIMEOUTms*MB_ONEMS)
#define MB_TURNAROUND_TIMEOUT   (MB_TURNAROUND_TIMEOUTms*MB_ONEMS)
#define MB_TXLOCK_TIMEOUT       (1*MB_ONEMS)
#endif

#include <mblocal.h>

#endif
