/* 
 * FreeModbus Libary: A portable Modbus implementation for Modbus ASCII/RTU.
    general types and language defines for platform scpecifics stuff library
    Copyright (C) 2015  Alexandr Litjagin (aka AlexRayne) AlexRaynePE196@gmail.com
                                                          AlexRaynePE196@hotbox.ru
   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
 *
 */

#ifndef _MB_CONFIG_H
#define _MB_CONFIG_H

#include <portgen.h>

#ifdef __cplusplus
PR_BEGIN_EXTERN_C
#endif
/* ----------------------- Defines ------------------------------------------*/
/*! \defgroup modbus_cfg Modbus Configuration
 *
 * Most modules in the protocol stack are completly optional and can be
 * excluded. This is specially important if target resources are very small
 * and program memory space should be saved.<br>
 *
 * All of these settings are available in the file <code>mbconfig.h</code>
 */
/*! \addtogroup modbus_cfg
 *  @{
 */
/*! \brief If Modbus ASCII support is enabled. */
#define MB_ASCII_ENABLED                        (  0 )
/*! \brief If Modbus RTU support is enabled. */
#define MB_RTU_ENABLED                          (  1 )
/*! \brief If Modbus TCP support is enabled. */
#define MB_TCP_ENABLED                          (  0 )
/*! \brief The character timeout value for Modbus ASCII.
 *
 * The character timeout value is not fixed for Modbus ASCII and is therefore
 * a configuration option. It should be set to the maximum expected delay
 * time of the network.
 */
#define MB_ASCII_TIMEOUT_SEC                    (  1 )

/*! \brief old function holdregisters implementation uses incremented 
 *      received adress value to pass to function handler. To skip it, 
 *      deine this macro
 *
 */
//#define PLAIN_HOLDREG_ADRESS_BEHAVIOUR

/*! \brief ModBus provides a couple variants of crc calculators for RTU, ASCII
 *      with different balanse over memory\speed.
 *   MODBUS_CRC_VARIANT selects with variant should be compiles. if not defined
 *   targetOs-specific crc should be used 
 * */
#define MODBUS_CRC_TABLE_8BIT     1
#define MODBUS_CRC_TABLE_16BIT    2
#define MODBUS_CRC_TABLE_NIBLE    3
//#define MODBUS_CRC_VARIANT          MODBUS_CRC_TABLE_NIBLE

/*! \brief old function handlers forced to use USHORT for frame length
 *      even on RSxxx hardware interface, with this macro length parameter
 *      type (UFRAMESIZE) now selected shortesr possible type
 *
 */
#define OPTIMAL_PARAMETERS

/*! \brief Maximum number of Modbus functions codes the protocol stack
 *    should support.
 *
 * The maximum number of supported Modbus functions must be greater than
 * the sum of all enabled functions in this file and custom function
 * handlers. If set to small adding more functions will fail.
 * \relatealso eMBRegisterCB()
 */
#define MB_FUNC_HANDLERS_MAX                    ( 8 )

/** if MB_CAN_UNREGISTER_CB defined - unregistering handler (pxHandler=NULL) will
*  free handlers table for new function, else - once registered function always
*  stay registered.
*  \relatealso eMBRegisterCB()
*  
*/
//#define MB_CAN_UNREGISTER_CB

/*! \brief Number of bytes which should be allocated for the <em>Report Slave ID
 *    </em>command.
 *
 * values:
 *  0 - denotes that no buffer for eMBSetSlaveID(... pucAdditional) use, but this 
 *      string are always availiable for modbus core, and used by reference 
 *      !!! this reference MUST be Avail for memcpy 
 *  N - 
 * This number limits the maximum size of the additional segment in the
 * report slave id function. See eMBSetSlaveID(  ) for more information on
 * how to set this value. It is only used if MB_FUNC_OTHER_REP_SLAVEID_ENABLED
 * is set to <code>1</code>.
 */
#define MB_FUNC_OTHER_REP_SLAVEID_BUF           ( 0 )
/*! \brief If the <em>Report Slave ID</em> function should be enabled. */
#define MB_FUNC_OTHER_REP_SLAVEID_ENABLED       (  1 )
/*! \brief Uses Read Holding Registers Function for Read Input Registers
 *  This optimisation reduce code size by share same handler
 * */
#define MB_READ_INPUT_AS_HOLDING                2
/*! \brief If the <em>Read Input Registers</em> function should be enabled. */
#define MB_FUNC_READ_INPUT_ENABLED              (  MB_READ_INPUT_AS_HOLDING )
/*! \brief If the <em>Read Holding Registers</em> function should be enabled. */
#define MB_FUNC_READ_HOLDING_ENABLED            (  1 )
/*! \brief If the <em>Write Single Register</em> function should be enabled. */
#define MB_FUNC_WRITE_HOLDING_ENABLED           (  1 )
/*! \brief If the <em>Write Multiple registers</em> function should be enabled. */
#define MB_FUNC_WRITE_MULTIPLE_HOLDING_ENABLED  (  1 )
/*! \brief If the <em>Read Coils</em> function should be enabled. */
#define MB_FUNC_READ_COILS_ENABLED              (  0 )
/*! \brief If the <em>Write Coils</em> function should be enabled. */
#define MB_FUNC_WRITE_COIL_ENABLED              (  0 )
/*! \brief If the <em>Write Multiple Coils</em> function should be enabled. */
#define MB_FUNC_WRITE_MULTIPLE_COILS_ENABLED    (  0 )
/*! \brief If the <em>Read Discrete Inputs</em> function should be enabled. */
#define MB_FUNC_READ_DISCRETE_INPUTS_ENABLED    (  0 )
/*! \brief If the <em>Read/Write Multiple Registers</em> function should be enabled. */
#define MB_FUNC_READWRITE_HOLDING_ENABLED       (  1 )
/*! @} */

#ifdef __cplusplus
    PR_END_EXTERN_C
#endif
#endif
