/*
 * FreeModbus Libary: AVR Port
 * Copyright (C) 2006 Christian Walter <wolti@sil.at>
 *   - Initial version + ATmega168 support
 * Modfications Copyright (C) 2006 Tran Minh Hoang:
 *   - ATmega8, ATmega16, ATmega32 support
 *   - RS485 support for DS75176
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 * File: $Id: port.h,v 1.6 2006/09/17 16:45:52 wolti Exp $
 */

#ifndef _PORT_H
#define _PORT_H

/* ----------------------- Platform includes --------------------------------*/

#include <avr/io.h>
#include <avr/interrupt.h>

#include "portgen.h"

/* ----------------------- AVR platform specifics ---------------------------*/

#if defined (__AVR_ATmega168__)
#define MBUCSRB           UCSR0B
#define MBTXEN            TXEN0
#define MBRXEN            RXEN0
#define MBRXCIE           RXCIE0
#define MBTXCIE           TXCIE0
#define MBUDRE            UDRE0
#define MBUBRR            UBRR0
#define MBUCSRC           UCSR0C
#define MBUPM1            UPM01
#define MBUPM0            UPM00
#define MBUCSZ0           UCSZ00
#define MBUCSZ1           UCSZ01
#define MBUDR             UDR0
#define MBSIG_UART_TRANS  SIG_USART_TRANS

#elif defined (__AVR_ATmega169__)

#define MBSIG_UART_TRANS  SIG_USART_TRANS

#elif defined (__AVR_ATmega8__)
#define MBUBRR            UBRR1L
#define MBTIMSK1          TIMSK
#define MBTIFR1           TIFR
#define MBSIG_USART_DATA  SIG_UART_DATA
#define MBSIG_USART_RECV  SIG_UART_RECV

#elif defined (__AVR_ATmega16__)
#define MBUBRR            UBRR1L
#define MBTIMSK1          TIMSK
#define MBTIFR1           TIFR

#elif defined (__AVR_ATmega32__)
#define MBUBRR            UBRR1L

#elif defined (__AVR_ATmega128__)\
       || defined (__AVR_ATmega162__)\
       || defined (__AVR_ATmega164P__) || defined (__AVR_ATmega164PA__)\
       || defined (__AVR_ATmega324P__) || defined (__AVR_ATmega324A__) || defined (__AVR_ATmega324PA__)\
       || defined (__AVR_ATmega644P__) || defined (__AVR_ATmega644A__) || defined (__AVR_ATmega644PA__)\
       || defined (__AVR_ATmega1284P__)
#define MBUCSRB           UCSR1B
#define MBUBRRL           UBRR1L
#define MBUBRRH           UBRR1H
#define MBUDR             UDR1
#define MBSIG_UART_TRANS  SIG_USART1_TRANS
#define MBSIG_USART_DATA  SIG_USART1_DATA
#define MBSIG_USART_RECV  SIG_USART1_RECV
#define MBUCSRC           UCSR1C

#define MBTXEN            TXEN1
#define MBRXEN            RXEN1
#define MBTXCIE           TXCIE1
#define MBRXCIE           RXCIE1
#define MBUDRE            UDRE1
#define MBUPM1            UPM11
#define MBUPM0            UPM10
#define MBUCSZ1           UCSZ11
#define MBUCSZ0           UCSZ10

    #if defined (__AVR_ATmega162__)
        #define MBURSEL   URSEL1
    #endif

#   if defined (__AVR_ATmega164P__) || defined (__AVR_ATmega164PA__)\
       || defined (__AVR_ATmega324P__) || defined (__AVR_ATmega324A__) || defined (__AVR_ATmega324PA__)\
       || defined (__AVR_ATmega644P__) || defined (__AVR_ATmega644A__) || defined (__AVR_ATmega644PA__)\
       || defined (__AVR_ATmega1284P__)

#define MBTIMSK           TIMSK2
#define MBTIFR            TIFR2
#define MBTCCR            TCCR2B
#define MBTCNT            TCNT2
#define MBOCR             OCR2A
#define MBOCF             OCF2A
#define MBOCIE            OCIE2A
#define MBSIG_OUTPUT_COMPARE SIG_OUTPUT_COMPARE2A

#   else
#define MBTIMSK           TIMSK
#define MBTIFR            TIFR
#define MBTCCR            TCCR2
#define MBTCNT            TCNT2
#define MBOCR             OCR2
#define MBOCF             OCF2
#define MBOCIE            OCIE2
#define MBSIG_OUTPUT_COMPARE SIG_OUTPUT_COMPARE2
#   endif

#endif

/* ----------------------- RS485 specifics ----------------------------------*/
#include "hwconfig.h"

#ifdef  RTS_ENABLE

#ifndef RTS_PIN
#   define RTS_PIN         URS1DIR_P
#   define RTS_DDR         URS1DIR_DDR
#   define RTS_PORT        URS1DIR_PORT
#endif

#define RTS_INIT        \
    do { \
        RTS_DDR |= _BV( RTS_PIN ); \
        RTS_PORT &= ~( _BV( RTS_PIN ) ); \
    } while( 0 );

#define RTS_HIGH        \
    do { \
        RTS_PORT |= _BV( RTS_PIN ); \
    } while( 0 );

#define RTS_LOW         \
    do { \
        RTS_PORT &= ~( _BV( RTS_PIN ) ); \
    } while( 0 );

#endif

#include <protoport.h>

#endif
