/* 
 * FreeModbus Libary: A portable Modbus implementation for Modbus ASCII/RTU.
 * Copyright (c) 2010 Alexandr Litjagin (aka AlexRayne) <alexraynepe196@lavabit.com>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#include <avr/io.h>
#include <avr/interrupt.h>

#include <hwconfig.h>
#include <contiki-conf.h>
#include <contiki.h>

#include <mb.h>
#include <portevent.h>
#include <mblocal.h>


const UCHAR     ucSlaveID[] = SlaveID;
#define ucSlaveIDsize ucSlaveStrIDsize(ucSlaveID)

PROCESS(modbus_poller,"modbus protocol control");

PROCESS_THREAD(modbus_poller, ev, data){
    eMBErrorCode    eStatus;

    PROCESS_BEGIN();


    eStatus = eMBInit( MB_RTU, MBAdress, 0, MB_BAUD, MB_PAR_EVEN );

    eStatus = eMBSetSlaveID( 0x34, TRUE, ucSlaveID, ucSlaveIDsize);

    /* Enable the Modbus Protocol Stack. */
    eStatus = eMBEnable(  );

    while(1) {
        do {
            ( void )eMBPoll(  );
        } while (MBHasEvent()) ;
        PROCESS_YIELD();
    }

    PROCESS_END();
    //eStatus = eMBDisable(  );
    //eStatus = eMBClose(  );
}
