package jp.sourceforge.freegantt.swing;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;

import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.plaf.metal.MetalBorders;
import javax.swing.plaf.metal.MetalLookAndFeel;

public class MenuItemBorder extends MetalBorders.ButtonBorder {
	private static final long serialVersionUID = 8189671028968570980L;

	public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
		ButtonModel model = ((AbstractButton)c).getModel();
		g.translate(x, y);
    
		if (model.isEnabled()) {
            boolean pressed = model.isPressed();

            if (pressed) {
                g.setColor(MetalLookAndFeel.getControlDarkShadow());
                g.fillRect(0, 0, w, 2);
                g.fillRect(0, 2, 2, h - 2);
                g.fillRect(w - 1, 1, 1, h - 1);
                g.fillRect(1, h - 1, w - 2, 1);
            }
            else if (model.isRollover()) {
            	 g.setColor(MetalLookAndFeel.getControlDarkShadow());
                 g.drawRect(0, 0, w - 1, h - 1);
            }
        }
    }


	public Insets getBorderInsets( Component c ) {
	    return new Insets(3, 3, 3, 3);
	}
	public Insets getBorderInsets(Component c, Insets newInsets) {
		newInsets.top = 3;
		newInsets.left = 3;
		newInsets.bottom = 3;
		newInsets.right = 3;
		return newInsets;
	}
}
