package jp.sourceforge.freegantt.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;

import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import javax.swing.undo.CompoundEdit;

import jp.sourceforge.freegantt.locale.Resource;
import jp.sourceforge.freegantt.util.WrapLayout;

public class HolidayRootPane extends JPanel {
	private static final long serialVersionUID = 2991953825084137233L;

	Application app;
	JPanel fixedList;
	HolidayTable additionalTable;
	JScrollPane additionalScrollPane;
	Map<Integer, JCheckBox> fixedHolidayCheckBoxMap = new HashMap<Integer, JCheckBox>();
	
	public HolidayRootPane(final Application app) {
		this.app = app;
		
		setLayout(new BoxLayout(this, BoxLayout.Y_AXIS));
		setBorder(new EmptyBorder(10, 10, 10, 10));
		app.getProject().getHolidayTableModel().addTableModelListener(new FixedHolidayModellListener());
		
		JLabel fixedLabel = new JLabel(Resource.get("holidayFixed"));
		fixedLabel.setAlignmentX(JComponent.LEFT_ALIGNMENT);
		add(fixedLabel);
		
		fixedList = new JPanel();
		fixedList.setLayout(new WrapLayout(WrapLayout.LEFT));
		fixedList.setMaximumSize(new Dimension(Integer.MAX_VALUE, 1));
		fixedList.setAlignmentX(JComponent.LEFT_ALIGNMENT);
		add(fixedList);
		
		SimpleDateFormat format = new SimpleDateFormat("EEE", Resource.getLocale());
		Calendar calendar = Calendar.getInstance();
		calendar.set(1970, 0, 5, 0, 0, 0);
		for (int i=0; i<7; i++) {
			final int week = (i + 1) % 7 + 1;
			final JCheckBox checkBox = new JCheckBox(format.format(calendar.getTime()));
			checkBox.setSelected(app.getProject().getFixedHolidays().contains(new Integer(week)));
			checkBox.addActionListener(new ActionListener(){
				@Override
				public void actionPerformed(ActionEvent e) {
					CompoundEdit compound = new CompoundEdit();
					app.getProject().getUndoManager().addEdit(compound);
					try {
						app.getProject().getController().setFixedHoliday(week, checkBox.isSelected());
						app.getProject().update();
					} finally {
						compound.end();
					}
				}
			});
			fixedList.add(checkBox);
			fixedHolidayCheckBoxMap.put(week, checkBox);
			calendar.add(Calendar.DAY_OF_MONTH, 1);
		}
		
		JLabel additionalHoliday = new JLabel(Resource.get("holidayAdditional"));
		additionalHoliday.setAlignmentX(JComponent.LEFT_ALIGNMENT);
		add(additionalHoliday);
		
		TableModel tableModel = app.getProject().getHolidayTableModel();
		tableModel.addTableModelListener(new TableModelListener(){
			@Override
			public void tableChanged(TableModelEvent e) {
				CompoundEdit compound = new CompoundEdit();
				app.getProject().getUndoManager().addEdit(compound);
				try {
					HolidayRootPane.this.app.getProject().update();
					HolidayRootPane.this.app.getProject().getTaskTableModel().fireTableChanged();
				} finally {
					compound.end();
					additionalTable.repaint();
				}
			}
		});
		
		additionalTable = new HolidayTable(app, tableModel);
		additionalScrollPane = new JScrollPane(additionalTable);
		additionalScrollPane.setPreferredSize(new Dimension(Integer.MAX_VALUE, 120));
		additionalScrollPane.setAlignmentX(JComponent.LEFT_ALIGNMENT);
		add(additionalScrollPane);
	}

	@Override
	public void doLayout() {
		super.doLayout();
		invalidate();
		super.doLayout();
		
		int otherHeight = 0;
		for (Component c: getComponents()) {
			if (c != additionalScrollPane) {
				otherHeight += c.getHeight();
			}
		}
		Rectangle r = additionalScrollPane.getBounds();
		additionalScrollPane.setBounds(r.x, r.y, r.width, getHeight() - 20 - otherHeight);
	}

	class FixedHolidayModellListener implements TableModelListener {
		@Override
		public void tableChanged(TableModelEvent e) {
			List<Integer> weeks = app.getProject().getFixedHolidays();
			for (Entry<Integer, JCheckBox> entry: fixedHolidayCheckBoxMap.entrySet()) {
				entry.getValue().setSelected(weeks.contains(entry.getKey()));
			}
		}
	}
}
