package jp.sourceforge.freegantt.data.undo;

import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

import jp.sourceforge.freegantt.data.Project;

public class UpdateTaskGroupEdit extends AbstractUndoableEdit {
	private static final long serialVersionUID = 2433458560313634203L;

	Project project;
	boolean oldGroup;
	boolean newGroup;
	int index;
	
	public UpdateTaskGroupEdit(Project project, boolean newGroup, int index) {
		this.project = project;
		this.oldGroup = project.getTaskAtIndex(index).isGroup();
		this.newGroup = newGroup;
		this.index = index;
	}

	@Override
	public void undo() throws CannotUndoException {
		System.out.println("Undo " + getClass().toString());
		super.undo();
		project.getController().setTaskGroup(oldGroup, index);
	}

	@Override
	public void redo() throws CannotRedoException {
		super.redo();
		project.getController().setTaskGroup(newGroup, index);
	}

	@Override
	public void die() {
		super.die();
		project = null;
	}
}
