﻿using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.IO;
using System.Threading.Tasks;
using System.Windows.Input;
using Windows.ApplicationModel.Store;
using Windows.Storage;
using Windows.Storage.AccessCache;
using Windows.Storage.Pickers;
using Windows.UI.Xaml;
using Windows.UI.Xaml.Controls;

namespace FooEditor
{
    class HomePageViewModel : ViewModelBase
    {
        public HomePageViewModel()
        {
            this.Items = new ObservableCollection<GroupItems>();
        }

        ObservableCollection<GroupItems> _Items;
        public ObservableCollection<GroupItems> Items
        {
            get { return this._Items; }
            private set
            {
                this._Items = value;
                this.OnPropertyChanged();
            }
        }

        public DelegateCommand<object> PurchaseCommand
        {
            get
            {
                return new DelegateCommand<object>(async (e) =>
                {
#if DEBUG
                    await CurrentAppSimulator.RequestAppPurchaseAsync(false);
#else
                    await CurrentApp.RequestAppPurchaseAsync(false);
#endif

                });
            }
        }

        public async Task LoadState(DocumentCollection collection)
        {
            var loader = new Windows.ApplicationModel.Resources.ResourceLoader();

            DelegateCommand<object> cmd;
            GroupItems item = new GroupItems(loader.GetString("NewListGroup"));

            cmd = new DelegateCommand<object>(async (param) =>
            {
                DocumentControl doc = new DocumentControl();

                doc.Title = string.Format(loader.GetString("NewDocumentTitle"), collection.Count);
                await doc.SetDocumentType((FileType)param);

                DocumentPageInfo info = new DocumentPageInfo(doc);
                collection.AddDocument(info);
            });
            foreach (FileType type in AppSettings.Current.FileTypeCollection)
                item.items.Add(new ButtonItem(type.DocumentTypeName, cmd, type));

            this.Items.Add(item);

            item = new GroupItems(loader.GetString("RecentListGroup"));

            item.items.Add(new ButtonItem(loader.GetString("OpenButton"),
                    new DelegateCommand<object>(async (param) =>
                    {
                        await collection.AddFromFilePicker();
                    })
                ));

            await this.GetRecentFiles(collection, item.items);

            this.Items.Add(item);
        }

        private async Task GetRecentFiles(DocumentCollection collection, ObservableCollection<IItem> items)
        {
            AccessListEntryView mruEntries = StorageApplicationPermissions.MostRecentlyUsedList.Entries;
            if (mruEntries.Count > 0)
            {
                var loader = new Windows.ApplicationModel.Resources.ResourceLoader();
                foreach (AccessListEntry entry in mruEntries)
                {
                    try
                    {
                        String token = entry.Token;
                        StorageFile mrudFile = await StorageApplicationPermissions.MostRecentlyUsedList.GetFileAsync(token);
                        DelegateCommand<StorageFile> cmd = new DelegateCommand<StorageFile>(async (file) =>
                        {
                            await collection.AddFromFile(file);
                        });
                        items.Add(new FileItem(mrudFile, cmd));
                    }
                    catch (FileNotFoundException)
                    {
                    }
                }
            }
        }
    }

    public class ItemGridViewTemplateSelector : DataTemplateSelector
    {
        public DataTemplate ButtonItem { get; set; }
        public DataTemplate RecentFileItem { get; set; }
        protected override DataTemplate SelectTemplateCore(object item, DependencyObject container)
        {
            FrameworkElement element = container as FrameworkElement;
            var data = item as IItem;
            if (data.IsButton)
            {
                return this.ButtonItem;
            }
            return this.RecentFileItem;
        }
    }

    public class GroupItems
    {
        private string _title;

        public string title
        {
            get
            {
                return _title;
            }
        }

        private ObservableCollection<IItem> _items = new ObservableCollection<IItem>();

        public ObservableCollection<IItem> items
        {
            get
            {
                return _items;
            }
        }
        public GroupItems(string title)
        {
            this._title = title;
        }
    }

    public interface IItem
    {
        bool IsButton
        {
            get;
        }
    }
    public struct ButtonItem : IItem
    {
        string _Title;
        ICommand _Command;
        FileType _DocumentType;
        public string Title
        {
            get
            {
                return _Title;
            }
        }
        public bool IsButton
        {
            get
            {
                return true;
            }
        }
        public ICommand Command
        {
            get
            {
                return _Command;
            }
        }
        public FileType DocumentType
        {
            get
            {
                return _DocumentType;
            }
        }
        public ButtonItem(string title, ICommand cmd, FileType doctype = null)
        {
            this._Command = cmd;
            this._Title = title;
            this._DocumentType = doctype;
        }
    }
    public struct FileItem : IItem
    {
        StorageFile _File;
        ICommand _Command;
        public StorageFile File
        {
            get
            {
                return _File;
            }
        }
        public bool IsButton
        {
            get
            {
                return false;
            }
        }
        public ICommand Command
        {
            get
            {
                return _Command;
            }
        }
        public FileItem(StorageFile file, DelegateCommand<StorageFile> cmd)
        {
            this._Command = cmd;
            this._File = file;
        }
    }
}
