﻿using System;
using System.Globalization;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Runtime.InteropServices.WindowsRuntime;
using Windows.Foundation;
using Windows.Foundation.Collections;
using Windows.UI.Xaml;
using Windows.UI.Xaml.Controls;
using Windows.UI.Xaml.Controls.Primitives;
using Windows.UI.Xaml.Data;
using Windows.UI.Xaml.Input;
using Windows.UI.Xaml.Media;
using Windows.UI.Xaml.Navigation;

// 設定フライアウトの項目テンプレートについては、http://go.microsoft.com/fwlink/?LinkId=273769 を参照してください

namespace FooEditor
{
    public sealed partial class PrintSettingsFlyout : SettingsFlyout
    {
        public PrintSettingsFlyout()
        {
            this.InitializeComponent();
            this.DataContext = new PrintSettingsFlyoutViewModel();
        }
    }

    sealed class PrintSettingsFlyoutViewModel : ViewModelBase
    {
        public bool IsMetric
        {
            get
            {
                return RegionInfo.CurrentRegion.IsMetric;
            }
        }
        public float TopMargin
        {
            get
            {
                return PrintModel.GetUnit(AppSettings.Current.TopMargin, this.IsMetric);
            }
            set
            {
                AppSettings.Current.TopMargin = PrintModel.GetPixel(value,this.IsMetric);
                this.OnPropertyChanged();
            }
        }
        public float RightMargin
        {
            get
            {
                return PrintModel.GetUnit(AppSettings.Current.RightMargin, this.IsMetric);
            }
            set
            {
                AppSettings.Current.RightMargin = PrintModel.GetPixel(value, this.IsMetric);
                this.OnPropertyChanged();
            }
        }
        public float BottomMargin
        {
            get
            {
                return PrintModel.GetUnit(AppSettings.Current.BottomMargin, this.IsMetric);
            }
            set
            {
                AppSettings.Current.BottomMargin = PrintModel.GetPixel(value, this.IsMetric);
                this.OnPropertyChanged();
            }
        }
        public float LeftMargin
        {
            get
            {
                return PrintModel.GetUnit(AppSettings.Current.LeftMargin,this.IsMetric);
            }
            set
            {
                AppSettings.Current.LeftMargin = PrintModel.GetPixel(value, this.IsMetric);
                this.OnPropertyChanged();
            }
        }
        public string Header
        {
            get
            {
                return AppSettings.Current.Header;
            }
            set
            {
                AppSettings.Current.Header = value;
                this.OnPropertyChanged();
            }
        }
        public string Footer
        {
            get
            {
                return AppSettings.Current.Footer;
            }
            set
            {
                AppSettings.Current.Footer = value;
                this.OnPropertyChanged();
            }
        }
    }
    sealed class PrintModel
    {
        static public int GetPixel(float n,bool ismetric)
        {
            float dpi = Windows.Graphics.Display.DisplayInformation.GetForCurrentView().LogicalDpi;
            if (ismetric)
                return (int)Math.Round(n / 25.4f * dpi);
            else
                return (int)Math.Round(n * dpi + 0.5);
        }
        static public float GetUnit(float px,bool ismetric)
        {
            float dpi = Windows.Graphics.Display.DisplayInformation.GetForCurrentView().LogicalDpi;
            if (ismetric)
                return (float)Math.Round(px * 25.4f / dpi);
            else
                return (float)Math.Round(px / dpi);

        }
    }
}
