﻿using System.Windows;
using System.Windows.Controls;
using FooEditEngine.WPF;

namespace FooEditor
{
    /// <summary>
    /// LineJumpDialog.xaml の相互作用ロジック
    /// </summary>
    public partial class LineJumpDialog : Window
    {
        public LineJumpDialog(FooTextBox textbox)
            : this()
        {
            this.Model = new LineJumpModel(textbox);
            this.ToRow = this.Model.ToRow;
            this.LineCount = this.Model.MaxRow;
        }
        /// <summary>
        /// コンストラクター
        /// </summary>
        public LineJumpDialog()
        {
            InitializeComponent();
            this.DataContext = this;
        }

        LineJumpModel Model;

        /// <summary>
        /// 移動先の行
        /// </summary>
        public int ToRow
        {
            get { return (int)GetValue(ToRowProperty); }
            set { SetValue(ToRowProperty, value); }
        }

        public static readonly DependencyProperty ToRowProperty =
            DependencyProperty.Register("ToRow", typeof(int), typeof(LineJumpDialog), new PropertyMetadata(0));

        /// <summary>
        /// 最大行数
        /// </summary>
        public int LineCount
        {
            get { return (int)GetValue(LineCountProperty); }
            set { SetValue(LineCountProperty, value); }
        }

        public static readonly DependencyProperty LineCountProperty =
            DependencyProperty.Register("LineCount", typeof(int), typeof(LineJumpDialog), new PropertyMetadata(0));

        private void OK_Click(object sender, RoutedEventArgs e)
        {
            var hasErros = Validation.GetErrors(this.JumpToTextBox);
            if (hasErros.Count == 0)
            {
                this.Model.JumpCaret(this.ToRow);
                this.Close();
            }
        }

        private void Cancle_Click(object sender, RoutedEventArgs e)
        {
            this.Close();
        }
    }
}
