﻿using System;
using System.Collections.Generic;
using System.Text.RegularExpressions;
using System.Windows.Forms;
using FooEditEngine;
using FooEditEngine.Windows;
using FooEditor.Properties;

namespace FooEditor
{
    public partial class FindReplaceDialog : WeifenLuo.WinFormsUI.Docking.DockContent
    {
        private FooTextBox _fooTextBox;
        private IEnumerator<SearchResult> sr;

        public FindReplaceDialog()
        {
            InitializeComponent();
        }

        public FindReplaceDialog(FooTextBox textBox) : this()
        {
            this.fooTextBox = textBox;
            button2.Enabled = false;
        }

        public FooTextBox fooTextBox
        {
            get { return this._fooTextBox; }
            set {
                this._fooTextBox = value;
                sr = null;
            }
        }
        
        private RegexOptions DecideRegexOpt()
        {
            RegexOptions opt = RegexOptions.None;
            if (checkBox1.Checked == true)
                opt |= RegexOptions.IgnoreCase;
            if (checkBox2.Checked == true)
                opt |= RegexOptions.ECMAScript;
            return opt;
        }

        private void button1_Click(object sender, EventArgs e)
        {
            if (this.fooTextBox.RectSelection)
            {
                MessageBox.Show(Resources.MustBeDisableRectSelect);
                return;
            }

            if (this.comboBox1.Items.Contains(this.comboBox1.Text) == false)
                this.comboBox1.Items.Add(this.comboBox1.Text);

            try
            {
                if (this.sr == null)
                {
                    this.fooTextBox.Document.SetFindParam(this.comboBox1.Text, this.checkBox4.Checked, DecideRegexOpt());
                    this.sr = this.fooTextBox.Document.Find();
                }
            }
            catch (ArgumentException ex)
            {
                throw new UserOperationException(ex.Message);
            }

            if (sr.MoveNext() == false)
            {
                this.sr = null;
                throw new UserOperationException(Resources.FindDialogNotFound);
            }

            SearchResult current = sr.Current;
            this.fooTextBox.JumpCaret(current.Start);
            this.fooTextBox.Select(current.Start, current.End - current.Start + 1);
            this.fooTextBox.Refresh();
            button2.Enabled = true;
        }        

        private void button2_Click(object sender, EventArgs e)
        {
            if (this.comboBox2.Items.Contains(this.comboBox2.Text) == false)
                this.comboBox2.Items.Add(this.comboBox2.Text);

            this.fooTextBox.SelectedText = this.sr.Current.Result(this.comboBox2.Text);
            this.fooTextBox.DeSelectAll();
            this.fooTextBox.Refresh();
            button1_Click(sender, e);
        }

        private void FindReplaceDialog_Load(object sender, EventArgs e)
        {
            if (this.Visible == false)
                return;
            if(this.fooTextBox.SelectionLength > 0)
                this.comboBox1.Text = this.fooTextBox.SelectedText;
            this.comboBox1.Focus();
        }

        private void button3_Click(object sender, EventArgs e)
        {
            if (this.fooTextBox.RectSelection)
            {
                throw new UserOperationException(Resources.MustBeDisableRectSelect);
            }

            this.fooTextBox.DeSelectAll();

            this.fooTextBox.Document.SetFindParam(this.comboBox1.Text, this.checkBox4.Checked, DecideRegexOpt());

            this.fooTextBox.Document.ReplaceAll(this.comboBox2.Text,this.checkBox3.Checked);

            this.fooTextBox.Refresh();

            throw new UserOperationException(Resources.FindDialogNotFound);
        }

        private void textBox1_TextChanged(object sender, EventArgs e)
        {
            this.sr = null;
            this.fooTextBox.DeSelectAll();
            this.fooTextBox.Refresh();
        }

        private void button5_Click(object sender, EventArgs e)
        {
            Help.ShowHelp(this, Resources.HelpFileName, HelpNavigator.Topic, "201037172845624.htm");
        }

        private void checkBox4_CheckedChanged(object sender, EventArgs e)
        {
            this.sr = null;
            this.fooTextBox.DeSelectAll();
            this.fooTextBox.Refresh();
        }

    }
}
