﻿using System;
using System.Collections.Generic;
using System.Text;
using System.IO;
using Windows.Storage.Pickers;
using Windows.Storage;
using Windows.UI.ViewManagement;
using Windows.UI.Xaml;
using Windows.UI.Xaml.Controls;
using Windows.UI.Xaml.Navigation;

// 空白ページのアイテム テンプレートについては、http://go.microsoft.com/fwlink/?LinkId=234238 を参照してください

namespace Test
{
    /// <summary>
    /// それ自体で使用できる空白ページまたはフレーム内に移動できる空白ページ。
    /// </summary>
    public sealed partial class MainPage : Page
    {
        public MainPage()
        {
            this.InitializeComponent();
        }

        /// <summary>
        /// このページがフレームに表示されるときに呼び出されます。
        /// </summary>
        /// <param name="e">このページにどのように到達したかを説明するイベント データ。Parameter 
        /// プロパティは、通常、ページを構成するために使用します。</param>
        protected override void OnNavigatedTo(NavigationEventArgs e)
        {
        }

        private async void Button_Click(object sender, RoutedEventArgs e)
        {
            FileOpenPicker openPicker = new FileOpenPicker();

            openPicker.ViewMode = PickerViewMode.List;

            // ファイル形式
            openPicker.FileTypeFilter.Add("*");

            // 最初に表示される場所
            openPicker.SuggestedStartLocation = PickerLocationId.DocumentsLibrary;

            StorageFile file = await openPicker.PickSingleFileAsync();
            if (file != null)
            {
                using (Stream stream = await file.OpenStreamForReadAsync())
                using(StreamReader reader = new StreamReader(stream))
                {
                    await this.fooTextBox.Document.LoadAsync(reader);
                    this.fooTextBox.FoldingStrategy = new CharFoldingMethod('{', '}');
                    this.fooTextBox.LayoutLineCollection.GenerateFolding();
                    this.fooTextBox.Refresh();
                }
            }
        }

        private async void Button_Click_1(object sender, RoutedEventArgs e)
        {
            FileSavePicker savePicker = new FileSavePicker();
            savePicker.SuggestedStartLocation = PickerLocationId.DocumentsLibrary;
            savePicker.FileTypeChoices.Add("Text Types", new List<string>() { ".txt" });
            savePicker.SuggestedStartLocation = PickerLocationId.DocumentsLibrary;
            StorageFile file = await savePicker.PickSaveFileAsync();
            if (file != null)
            {
                using (Stream stream = await file.OpenStreamForWriteAsync())
                using (StreamWriter writer = new StreamWriter(stream))
                {
                    await this.fooTextBox.Document.SaveAsync(writer);
                }
            }
        }

    }
}
