﻿using System;
using SharpDX;
using D2D = SharpDX.Direct2D1;
using DW = SharpDX.DirectWrite;

namespace FooEditEngine
{
    class CustomTextRenderer : CallbackBase, DW.TextRenderer
    {
        readonly D2D.RenderTarget render;
        readonly D2D.SolidColorBrush defalutFore;

        public CustomTextRenderer(D2D.RenderTarget render, D2D.SolidColorBrush defalut)
        {
            this.render = render;
            this.defalutFore = defalut;
        }

        #region TextRenderer Members

        public Result DrawGlyphRun(object clientDrawingContext, float baselineOriginX, float baselineOriginY, D2D.MeasuringMode measuringMode, DW.GlyphRun glyphRun, DW.GlyphRunDescription glyphRunDescription, ComObject clientDrawingEffect)
        {
            D2D.SolidColorBrush foreBrush = defalutFore;
            if (clientDrawingEffect != null)
            {
                if (clientDrawingEffect is DrawingEffect)
                {
                    DrawingEffect effect;
                    effect = clientDrawingEffect as DrawingEffect;
                    foreBrush = effect.ForeBrush;
                }
                else if (clientDrawingEffect is D2D.SolidColorBrush)
                {
                    D2D.SolidColorBrush effect;
                    effect = clientDrawingEffect as D2D.SolidColorBrush;
                    foreBrush = effect;
                }
            }

            render.DrawGlyphRun(new DrawingPointF(baselineOriginX, baselineOriginY),
                glyphRun,
                foreBrush,
                measuringMode);

            return SharpDX.Result.Ok;
        }

        public Result DrawInlineObject(object clientDrawingContext, float originX, float originY, DW.InlineObject inlineObject, bool isSideways, bool isRightToLeft, ComObject clientDrawingEffect)
        {
            inlineObject.Draw(this.render, this, originX, originY, isSideways, isRightToLeft, clientDrawingEffect);
            return Result.Ok;
        }

        public Result DrawStrikethrough(object clientDrawingContext, float baselineOriginX, float baselineOriginY, ref DW.Strikethrough strikethrough, ComObject clientDrawingEffect)
        {
            D2D.SolidColorBrush foreBrush = defalutFore;
            DrawingEffect effect = null;
            if (clientDrawingEffect != null && clientDrawingEffect is DrawingEffect)
            {
                effect = clientDrawingEffect as DrawingEffect;
                foreBrush = effect.ForeBrush;
            }
            if (foreBrush == defalutFore)
            {
                render.DrawLine(new DrawingPointF(baselineOriginX, baselineOriginY + strikethrough.Offset),
                    new DrawingPointF(baselineOriginX + strikethrough.Width, baselineOriginY + strikethrough.Offset),
                    foreBrush,
                    strikethrough.Thickness);
            }
            else
            {
                render.DrawLine(new DrawingPointF(baselineOriginX, baselineOriginY + strikethrough.Offset),
                    new DrawingPointF(baselineOriginX + strikethrough.Width, baselineOriginY + strikethrough.Offset),
                    foreBrush,
                    strikethrough.Thickness,
                    effect.Stroke);
            }
            return Result.Ok;
        }

        public Result DrawUnderline(object clientDrawingContext, float baselineOriginX, float baselineOriginY, ref DW.Underline underline, ComObject clientDrawingEffect)
        {
            D2D.SolidColorBrush foreBrush = defalutFore;
            DrawingEffect effect = null;
            if (clientDrawingEffect != null && clientDrawingEffect is DrawingEffect)
            {
                effect = clientDrawingEffect as DrawingEffect;
                foreBrush = effect.ForeBrush;
            }
            if (foreBrush == defalutFore)
            {
                render.DrawLine(new DrawingPointF(baselineOriginX, baselineOriginY + underline.Offset),
                    new DrawingPointF(baselineOriginX + underline.Width, baselineOriginY + underline.Offset),
                    foreBrush,
                    underline.Thickness);
            }
            else
            {
                render.DrawLine(new DrawingPointF(baselineOriginX, baselineOriginY + underline.Offset),
                    new DrawingPointF(baselineOriginX + underline.Width, baselineOriginY + underline.Offset),
                    foreBrush,
                    underline.Thickness,
                    effect.Stroke);
            }

            return SharpDX.Result.Ok;
        }

        #endregion

        #region PixelSnapping Members

        public DW.Matrix GetCurrentTransform(object clientDrawingContext)
        {
            Matrix3x2 d2Dmatrix = render.Transform;
            var dwMatrix = new SharpDX.DirectWrite.Matrix()
            {
                M11 = d2Dmatrix.M11,
                M12 = d2Dmatrix.M12,
                M21 = d2Dmatrix.M22,
                M22 = d2Dmatrix.M22,
                Dx = d2Dmatrix.M31,
                Dy = d2Dmatrix.M32
            };
            return dwMatrix;
        }

        public float GetPixelsPerDip(object clientDrawingContext)
        {
            return render.PixelSize.Width / 96f;
        }

        public bool IsPixelSnappingDisabled(object clientDrawingContext)
        {
            return false;
        }

        #endregion
    }
}
