﻿using System;
using System.Collections.Generic;
using SharpDX;
using DW = SharpDX.DirectWrite;

namespace FooEditEngine
{
    class MyTextLayout : DW.TextLayout
    {
        DW.LineMetrics[] LineMetrics;

        public MyTextLayout(DW.Factory factory, string str, DW.TextFormat format, Size size)
            : base(factory, str, format, (float)size.Width, (float)size.Height)
        {
            this.Drew = false;
        }

        public bool Drew;

        public new DW.LineMetrics[] GetLineMetrics()
        {
            if (this.LineMetrics == null)    //キャッシュしないと多数の例外が発生する
                this.LineMetrics = base.GetLineMetrics();
            return this.LineMetrics;
        }
    }
}
