﻿using System;
using SharpDX;
using D2D = SharpDX.Direct2D1;

namespace FooEditEngine
{
    enum LineType
    {
        None,
        Squiggle,
    }
    class DrawingEffect : ComObject,IDisposable
    {
        public D2D.StrokeStyle Stroke;
        public Color4 Fore;
        public LineType StrokeType;
        public DrawingEffect(D2D.StrokeStyle stroke, Color4 fore,LineType type = LineType.None)
        {
            this.Stroke = stroke;
            this.Fore = fore;
            this.StrokeType = type;
        }

        void IDisposable.Dispose()
        {
            if(this.Stroke != null)
                this.Stroke.Dispose();
        }
    }
}
