#include "DWindowRender.h"

using namespace DWriteWarpper;

DWindowRender::DWindowRender(ID2D1HwndRenderTarget* render) : DRenderBase(render)
{
}

ID2D1HwndRenderTarget* DWindowRender::hwndRender::get()
{
	ID2D1HwndRenderTarget* hwndRender = static_cast<ID2D1HwndRenderTarget*>(render);

	return hwndRender;
}

void DWindowRender::Resize(unsigned int width,unsigned int height)
{
	D2D1_SIZE_U size = D2D1::SizeU(width,height);

	hwndRender->Resize(size);
}

DWindowState DWindowRender::CheckWindowState()
{
	return (DWindowState)hwndRender->CheckWindowState();
}

DWindowRender::~DWindowRender(void)
{
	GC::SuppressFinalize(this);
}

DWindowRender::!DWindowRender()
{
}
