#include "DTextFormat.h"

using namespace DWriteWarpper;

DTextFormat::DTextFormat(IDWriteTextFormat* pTextFormat)
{
	if(pTextFormat == NULL)
		throw gcnew ArgumentNullException("pTextFormat_ is NULL");

	pTextFormat_ = pTextFormat;
	disposed = false;
}

IDWriteTextFormat* DTextFormat::dwTextFormat::get()
{
	return this->pTextFormat_;
}

DReadingDirection DTextFormat::ReadingDirection::get()
{
	DWRITE_READING_DIRECTION direction = pTextFormat_->GetReadingDirection();
	switch(direction)
	{
		case DWRITE_READING_DIRECTION_LEFT_TO_RIGHT:
			return DReadingDirection::LeftToRight;
			break;
		case DWRITE_READING_DIRECTION_RIGHT_TO_LEFT:
			return DReadingDirection::RightToLeft;
			break;
	}
	throw "get ReadingDirection Error";
}
void DTextFormat::ReadingDirection::set(DReadingDirection value)
{
	HRESULT hr;
	switch(value)
	{
	case DReadingDirection::LeftToRight:
		hr = pTextFormat_->SetReadingDirection(DWRITE_READING_DIRECTION_LEFT_TO_RIGHT);
		break;
	case DReadingDirection::RightToLeft:
		hr = pTextFormat_->SetReadingDirection(DWRITE_READING_DIRECTION_RIGHT_TO_LEFT);
		break;
	}

	if(hr != S_OK)
		throw "SetReadingDirection error";
}
DWordWrapping DTextFormat::WordWrapping::get()
{
	DWRITE_WORD_WRAPPING wrapping = pTextFormat_->GetWordWrapping();
	switch(wrapping)
	{
		case DWRITE_WORD_WRAPPING_WRAP:
			return DWordWrapping::Wrapping;
			break;
		case DWRITE_WORD_WRAPPING_NO_WRAP:
			return DWordWrapping::NoWrapping;
			break;
	}
	throw "get WordWrapping Error";
}

void DTextFormat::WordWrapping::set(DWordWrapping value)
{
	HRESULT hr;

	switch(value)
	{
		case DWordWrapping::Wrapping:
			hr = pTextFormat_->SetWordWrapping(DWRITE_WORD_WRAPPING_WRAP);
			break;
		case DWordWrapping::NoWrapping:
			hr = pTextFormat_->SetWordWrapping(DWRITE_WORD_WRAPPING_NO_WRAP);
			break;
	}

	if(hr != S_OK)
		throw "SetWordWrapping error";
}
float DTextFormat::TabWidth::get() {
	return pTextFormat_->GetIncrementalTabStop();
}

void DTextFormat::TabWidth::set(float value) {
	HRESULT hr;

	hr = pTextFormat_->SetIncrementalTabStop(value);

	if(hr != S_OK)
		throw "SetIncrementalTabStop error";
}

DTextFormat::~DTextFormat(void)
{
	GC::SuppressFinalize(this);
	this->!DTextFormat();
}

DTextFormat::!DTextFormat()
{
	if(disposed)
		return;
	if(DWriteWarpper::SafeRelease(pTextFormat_))
		pTextFormat_ = NULL;
	disposed = true;
}
