#include "DDrawingEffect.h"

using namespace DWriteWarpper;

DDrawingEffect::DDrawingEffect(DrawingEffect* dwEffect)
{
	effect = dwEffect;

	ID2D1SolidColorBrush* brush;

	effect->GetForeColor(&brush);
	brush->AddRef();
	_foreBrush = gcnew DColorBrush(brush);

	effect->GetBackColor(&brush);
	brush->AddRef();
	_backBrush = gcnew DColorBrush(brush);

	disposed = false;
}

DrawingEffect* DDrawingEffect::dwEffect::get() { return this->effect; }

DColorBrush^ DDrawingEffect::Fore::get() { return this->_foreBrush; }

DColorBrush^ DDrawingEffect::Back::get() { return this->_backBrush; }

DDrawingEffect::DDrawingEffect(DWindowRender^ render,Color2F fore)
{
	_foreBrush = render->CreateBrush(fore);
	effect = new DrawingEffect(_foreBrush->brush,NULL);
	effect->AddRef();
	disposed = false;
}

DDrawingEffect::DDrawingEffect(DWindowRender^ render,Color2F fore,Color2F back)
{
	_foreBrush = render->CreateBrush(fore);
	_backBrush = render->CreateBrush(back);
	effect = new DrawingEffect(_foreBrush->brush,_backBrush->brush);
	effect->AddRef();
	disposed = false;
}

DDrawingEffect::~DDrawingEffect()
{
	GC::SuppressFinalize(this);
	this->!DDrawingEffect();
}

DDrawingEffect::!DDrawingEffect()
{
	if(disposed)
		return;
	int cRefCount = effect->Release();
	delete _foreBrush;
	if(_backBrush == nullptr)
		delete _backBrush;
	disposed = true;
}
